/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.v1.HeaderV1;
import com.navercorp.pinpoint.io.header.v2.HeaderV2;
import com.navercorp.pinpoint.io.util.BodyFactory;
import com.navercorp.pinpoint.io.util.HeaderFactory;
import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.io.util.TypeLocatorBuilder;
import com.navercorp.pinpoint.thrift.dto.flink.TFAgentStatBatch;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkTBaseLocator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final short AGENT_STAT_BATCH = 1000;
    private final byte version;
    private final TypeLocator<TBase<?, ?>> typeLocator;

    public FlinkTBaseLocator(byte version) {
        if (version != 16 && version != 32) {
            throw new IllegalArgumentException(String.format("could not select match header version. : 0x%02X", version));
        }
        this.version = version;
        this.typeLocator = this.newTypeLocator();
    }

    private TypeLocator<TBase<?, ?>> newTypeLocator() {
        FlinkHeaderFactory headerFactory = new FlinkHeaderFactory();
        TypeLocatorBuilder typeLocatorBuilder = new TypeLocatorBuilder(headerFactory);
        typeLocatorBuilder.addBodyFactory((short)1000, new BodyFactory<TBase<?, ?>>(){

            @Override
            public TBase<?, ?> getObject() {
                return new TFAgentStatBatch();
            }
        });
        return typeLocatorBuilder.build();
    }

    public TypeLocator<TBase<?, ?>> getTypeLocator() {
        return this.typeLocator;
    }

    public class FlinkHeaderFactory
    implements HeaderFactory {
        @Override
        public Header newHeader(short type) {
            return this.createHeader(type);
        }

        private Header createHeader(short type) {
            if (FlinkTBaseLocator.this.version == 16) {
                return this.createHeaderV1(type);
            }
            if (FlinkTBaseLocator.this.version == 32) {
                return this.createHeaderV2(type);
            }
            throw new IllegalArgumentException("unsupported Header version : " + FlinkTBaseLocator.this.version);
        }

        private Header createHeaderV1(short type) {
            return new HeaderV1(type);
        }

        private Header createHeaderV2(short type) {
            return new HeaderV2(-17, 32, type);
        }
    }
}

