/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.lettuce.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor;
import io.lettuce.core.RedisURI;

public class RedisClientConstructorInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public RedisClientConstructorInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
    }

    public void before(Object target, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                if (!this.validate(target, args)) {
                    return;
                }
                RedisURI redisURI = (RedisURI)args[1];
                String endPoint = HostAndPort.toHostAndPortString((String)redisURI.getHost(), (int)redisURI.getPort());
                ((EndPointAccessor)target)._$PINPOINT$_setEndPoint(endPoint);
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length < 2 || args[1] == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid arguments. Null or not found args({}).", args);
            }
            return false;
        }
        if (!(target instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)EndPointAccessor.class.getName());
            }
            return false;
        }
        if (!(args[1] instanceof RedisURI)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[1] object. args[1]={}", args[1]);
            }
            return false;
        }
        return true;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }
}

