/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;

public class ServerOption {
    private static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 3000L;
    private static final long DEFAULT_SERVER_CLOSE_WAIT_TIMEOUT_MILLIS = 3000L;
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL_TIME_MILLIS = 300000L;
    private static final long DEFAULT_HEALTH_CHECK_PACKET_WAIT_TIME_MILLIS = 1800000L;
    private static final ClusterOption DEFAULT_CLUSTER_OPTION = ClusterOption.DISABLE_CLUSTER_OPTION;
    private static final ServerOption DEFAULT_INSTANCE = new Builder().build();
    private final long requestTimeoutMillis;
    private final long serverCloseWaitTimeoutMillis;
    private final long healthCheckIntervalTimeMillis;
    private final long healthCheckPacketWaitTimeMillis;
    private final ClusterOption clusterOption;

    public static ServerOption getDefaultServerOption() {
        return DEFAULT_INSTANCE;
    }

    private ServerOption(long requestTimeoutMillis, long serverCloseWaitTimeoutMillis, long healthCheckIntervalTimeMillis, long healthCheckPacketWaitTimeMillis, ClusterOption clusterOption) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.serverCloseWaitTimeoutMillis = serverCloseWaitTimeoutMillis;
        this.healthCheckIntervalTimeMillis = healthCheckIntervalTimeMillis;
        this.healthCheckPacketWaitTimeMillis = healthCheckPacketWaitTimeMillis;
        this.clusterOption = clusterOption;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public long getServerCloseWaitTimeoutMillis() {
        return this.serverCloseWaitTimeoutMillis;
    }

    public long getHealthCheckIntervalTimeMillis() {
        return this.healthCheckIntervalTimeMillis;
    }

    public long getHealthCheckPacketWaitTimeMillis() {
        return this.healthCheckPacketWaitTimeMillis;
    }

    public ClusterOption getClusterOption() {
        return this.clusterOption;
    }

    public String toString() {
        return "ServerOption{requestTimeoutMillis=" + this.requestTimeoutMillis + ", serverCloseWaitTimeoutMillis=" + this.serverCloseWaitTimeoutMillis + ", healthCheckIntervalTimeMillis=" + this.healthCheckIntervalTimeMillis + ", healthCheckPacketWaitTimeMillis=" + this.healthCheckPacketWaitTimeMillis + ", clusterOption=" + this.clusterOption + '}';
    }

    static /* synthetic */ ClusterOption access$000() {
        return DEFAULT_CLUSTER_OPTION;
    }

    public static class Builder {
        private long requestTimeoutMillis = 3000L;
        private long serverCloseWaitTimeoutMillis = 3000L;
        private long healthCheckIntervalTimeMillis = 300000L;
        private long healthCheckPacketWaitTimeMillis = 1800000L;
        private ClusterOption clusterOption = ServerOption.access$000();

        public long getRequestTimeoutMillis() {
            return this.requestTimeoutMillis;
        }

        public void setRequestTimeoutMillis(long requestTimeoutMillis) {
            Assert.isTrue((requestTimeoutMillis > 0L ? 1 : 0) != 0, (String)"requestTimeoutMillis cannot be a negative number");
            this.requestTimeoutMillis = requestTimeoutMillis;
        }

        public long getServerCloseWaitTimeoutMillis() {
            return this.serverCloseWaitTimeoutMillis;
        }

        public void setServerCloseWaitTimeoutMillis(long serverCloseWaitTimeoutMillis) {
            Assert.isTrue((serverCloseWaitTimeoutMillis > 0L ? 1 : 0) != 0, (String)"serverCloseWaitTimeoutMillis cannot be a negative number");
            this.serverCloseWaitTimeoutMillis = serverCloseWaitTimeoutMillis;
        }

        public long getHealthCheckIntervalTimeMillis() {
            return this.healthCheckIntervalTimeMillis;
        }

        public void setHealthCheckIntervalTimeMillis(long healthCheckIntervalTimeMillis) {
            Assert.isTrue((healthCheckIntervalTimeMillis > 0L ? 1 : 0) != 0, (String)"healthCheckIntervalTimeMillis cannot be a negative number");
            this.healthCheckIntervalTimeMillis = healthCheckIntervalTimeMillis;
        }

        public long getHealthCheckPacketWaitTimeMillis() {
            return this.healthCheckPacketWaitTimeMillis;
        }

        public void setHealthCheckPacketWaitTimeMillis(long healthCheckPacketWaitTimeMillis) {
            Assert.isTrue((healthCheckPacketWaitTimeMillis > 0L ? 1 : 0) != 0, (String)"healthCheckPacketWaitTimeMillis cannot be a negative number");
            this.healthCheckPacketWaitTimeMillis = healthCheckPacketWaitTimeMillis;
        }

        public ClusterOption getClusterOption() {
            return this.clusterOption;
        }

        public void setClusterOption(ClusterOption clusterOption) {
            this.clusterOption = (ClusterOption)Assert.requireNonNull((Object)clusterOption, (String)"clusterOption must not be null");
        }

        public ServerOption build() {
            return new ServerOption(this.requestTimeoutMillis, this.serverCloseWaitTimeoutMillis, this.healthCheckIntervalTimeMillis, this.healthCheckPacketWaitTimeMillis, this.clusterOption);
        }
    }
}

