/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ApplicationServerTypePluginResolver;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServerTypeResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceType defaultType;
    private final ApplicationServerTypePluginResolver resolver;

    public ApplicationServerTypeResolver(List<ApplicationTypeDetector> applicationTypeDetector, ServiceType defaultType, List<String> orderedDetectors) {
        if (applicationTypeDetector == null) {
            throw new NullPointerException("applicationTypeDetector must not be null");
        }
        this.defaultType = this.isValidApplicationServerType(defaultType) ? defaultType : ServiceType.UNDEFINED;
        List<ApplicationTypeDetector> sortedDetectors = this.sortByOrder(orderedDetectors, applicationTypeDetector);
        this.resolver = new ApplicationServerTypePluginResolver(sortedDetectors);
    }

    private List<ApplicationTypeDetector> sortByOrder(List<String> orderedDetectors, List<ApplicationTypeDetector> applicationTypeDetectors) {
        ArrayList<ApplicationTypeDetector> detectionOrder = new ArrayList<ApplicationTypeDetector>();
        Map<String, ApplicationTypeDetector> applicationTypeDetectorMap = this.toMap(applicationTypeDetectors);
        for (String orderedDetector : orderedDetectors) {
            if (!applicationTypeDetectorMap.containsKey(orderedDetector)) continue;
            detectionOrder.add(applicationTypeDetectorMap.remove(orderedDetector));
        }
        detectionOrder.addAll(applicationTypeDetectorMap.values());
        return detectionOrder;
    }

    private Map<String, ApplicationTypeDetector> toMap(List<ApplicationTypeDetector> applicationTypeDetectorList) {
        HashMap<String, ApplicationTypeDetector> typeDetectorMap = new HashMap<String, ApplicationTypeDetector>();
        for (ApplicationTypeDetector applicationTypeDetector : applicationTypeDetectorList) {
            typeDetectorMap.put(applicationTypeDetector.getClass().getName(), applicationTypeDetector);
        }
        return typeDetectorMap;
    }

    public ServiceType resolve() {
        ServiceType resolvedApplicationServerType;
        if (this.defaultType == ServiceType.UNDEFINED) {
            resolvedApplicationServerType = this.resolver.resolve();
            this.logger.info("Resolved ApplicationServerType : {}", (Object)resolvedApplicationServerType.getName());
        } else {
            resolvedApplicationServerType = this.defaultType;
            this.logger.info("Configured ApplicationServerType : {}", (Object)resolvedApplicationServerType.getName());
        }
        return resolvedApplicationServerType;
    }

    private boolean isValidApplicationServerType(ServiceType serviceType) {
        if (serviceType == null) {
            return false;
        }
        return serviceType.isWas();
    }
}

