/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.profiler.sender.SpanStreamSendData;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class StandbySpanStreamDataStorage {
    private static final int DEFAULT_CAPACITY = 5;
    private static final long DEFAULT_MAX_WAIT_TIME = 5000L;
    private final int capacity;
    private final long maxWaitTimeMillis;
    private final PriorityQueue<SpanStreamSendData> priorityQueue;

    StandbySpanStreamDataStorage() {
        this(5, 5000L);
    }

    StandbySpanStreamDataStorage(int capacity, long maxWaitTimeMillis) {
        this.capacity = capacity;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.priorityQueue = new PriorityQueue<SpanStreamSendData>(capacity, new SpanStreamSendDataComparator());
    }

    synchronized boolean addStandbySpanStreamData(SpanStreamSendData standbySpanStreamData) {
        SpanStreamSendDataMode flushMode = standbySpanStreamData.getFlushMode();
        if (flushMode == SpanStreamSendDataMode.FLUSH) {
            return false;
        }
        if (standbySpanStreamData.getAvailableBufferCapacity() > 0 && standbySpanStreamData.getAvailableGatheringComponentsCount() > 0) {
            if (this.priorityQueue.size() >= this.capacity) {
                return false;
            }
            return this.priorityQueue.offer(standbySpanStreamData);
        }
        return false;
    }

    synchronized SpanStreamSendData getStandbySpanStreamSendData(int availableCapacity) {
        Iterator<SpanStreamSendData> standbySpanStreamSendDataIterator = this.priorityQueue.iterator();
        while (standbySpanStreamSendDataIterator.hasNext()) {
            SpanStreamSendData standbySpanStreamSendData = standbySpanStreamSendDataIterator.next();
            if (standbySpanStreamSendData.getAvailableBufferCapacity() <= availableCapacity) continue;
            standbySpanStreamSendDataIterator.remove();
            return standbySpanStreamSendData;
        }
        return null;
    }

    synchronized SpanStreamSendData getStandbySpanStreamSendData() {
        SpanStreamSendData mostAvailableBufferCapacityStreamSendData = null;
        for (SpanStreamSendData standbySpanStreamSendData : this.priorityQueue) {
            if (mostAvailableBufferCapacityStreamSendData == null) {
                mostAvailableBufferCapacityStreamSendData = standbySpanStreamSendData;
                continue;
            }
            if (mostAvailableBufferCapacityStreamSendData.getAvailableBufferCapacity() >= standbySpanStreamSendData.getAvailableBufferCapacity()) continue;
            mostAvailableBufferCapacityStreamSendData = standbySpanStreamSendData;
        }
        if (mostAvailableBufferCapacityStreamSendData != null) {
            this.priorityQueue.remove(mostAvailableBufferCapacityStreamSendData);
        }
        return mostAvailableBufferCapacityStreamSendData;
    }

    synchronized List<SpanStreamSendData> getForceFlushSpanStreamDataList() {
        SpanStreamSendData standbySpanStreamSendData;
        ArrayList<SpanStreamSendData> forceFlushSpanStreamDataList = new ArrayList<SpanStreamSendData>(this.capacity);
        long currentTimeMillis = System.currentTimeMillis();
        while ((standbySpanStreamSendData = this.priorityQueue.peek()) != null && standbySpanStreamSendData.getFirstAccessTime() + this.maxWaitTimeMillis < currentTimeMillis) {
            this.priorityQueue.remove();
            forceFlushSpanStreamDataList.add(standbySpanStreamSendData);
        }
        return forceFlushSpanStreamDataList;
    }

    synchronized long getLeftWaitTime(long defaultLeftWaitTime) {
        SpanStreamSendData standbySpanStreamSendData = this.priorityQueue.peek();
        if (standbySpanStreamSendData == null) {
            return defaultLeftWaitTime;
        }
        long firstAccessTime = standbySpanStreamSendData.getFirstAccessTime();
        return firstAccessTime + this.maxWaitTimeMillis - System.currentTimeMillis();
    }

    static class SpanStreamSendDataComparator
    implements Comparator<SpanStreamSendData> {
        SpanStreamSendDataComparator() {
        }

        @Override
        public int compare(SpanStreamSendData newValue, SpanStreamSendData oldValue) {
            if (newValue.getFirstAccessTime() == -1L) {
                return 1;
            }
            if (newValue.getFirstAccessTime() < oldValue.getFirstAccessTime()) {
                return -1;
            }
            return 1;
        }
    }
}

