/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStorageFactory
implements StorageFactory {
    public static final Storage DEFAULT_STORAGE = new LogStorage();

    @Override
    public Storage createStorage(TraceRoot traceRoot) {
        return DEFAULT_STORAGE;
    }

    public static class LogStorage
    implements Storage {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        @Override
        public void store(SpanEvent spanEvent) {
            this.logger.debug("log spanEvent:{}", (Object)spanEvent);
        }

        @Override
        public void store(Span span) {
            this.logger.debug("log span:{}", (Object)span);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

