/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.JdbcUrlParsingService;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DefaultDataSourceMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceMetricProvider
implements Provider<DataSourceMetric> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DataSourceMonitorRegistryService dataSourceMonitorRegistryService;
    private final JdbcUrlParsingService jdbcUrlParsingService;

    @Inject
    public DataSourceMetricProvider(DataSourceMonitorRegistryService dataSourceMonitorRegistryService, JdbcUrlParsingService jdbcUrlParsingService) {
        this.dataSourceMonitorRegistryService = dataSourceMonitorRegistryService;
        this.jdbcUrlParsingService = jdbcUrlParsingService;
    }

    public DataSourceMetric get() {
        DataSourceMetric dataSourceMetric = this.newDataSourceMetric();
        this.logger.info("loaded : {}", (Object)dataSourceMetric);
        return dataSourceMetric;
    }

    private DataSourceMetric newDataSourceMetric() {
        if (this.dataSourceMonitorRegistryService == null || this.jdbcUrlParsingService == null) {
            return DataSourceMetric.UNSUPPORTED_DATA_SOURCE_METRIC;
        }
        return new DefaultDataSourceMetric(this.dataSourceMonitorRegistryService, this.jdbcUrlParsingService);
    }
}

