/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.navercorp.pinpoint.common.plugin.JarFileUtils;
import com.navercorp.pinpoint.common.plugin.JarPlugin;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPluginLoader
implements PluginLoader {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader parentClassLoader;
    private final List<Entry> serviceLoaderList;

    public JarPluginLoader(List<String> pluginJar, ClassLoader parentClassLoader) {
        this.serviceLoaderList = this.loadPluginJar(pluginJar);
        this.parentClassLoader = parentClassLoader;
    }

    private List<Entry> loadPluginJar(List<String> pluginJar) {
        Assert.requireNonNull(pluginJar, (String)"pluginJar must not be null");
        return this.isolationPolicy(pluginJar);
    }

    private List<Entry> isolationPolicy(List<String> pluginJar) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (String filePath : pluginJar) {
            File file = this.toFile(filePath);
            URL url = this.toUrl(file);
            ClassLoader pluginClassLoader = this.createPluginClassLoader(new URL[]{url}, this.parentClassLoader);
            Entry entry = new Entry(url, file, pluginClassLoader);
            list.add(entry);
        }
        return list;
    }

    private URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL:" + file);
        }
    }

    private File toFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException(file + " File not exist");
        }
        if (!file.isFile()) {
            throw new RuntimeException(file + " is not file");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file + " File cannot be read");
        }
        return file;
    }

    private ClassLoader createPluginClassLoader(final URL[] urls, final ClassLoader parent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createPluginClassLoader(urls = [{}], parent = [{}])", (Object)Arrays.toString(urls), (Object)parent);
        }
        if (SECURITY_MANAGER != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new URLClassLoader(urls, parent);
                }
            });
        }
        return new URLClassLoader(urls, parent);
    }

    private static <T> List<T> toList(Iterable<T> iterable, Class<T> serviceType) {
        ArrayList<T> list = new ArrayList<T>();
        for (T plugin : iterable) {
            list.add(serviceType.cast(plugin));
        }
        return list;
    }

    public <T> List<Plugin<T>> load(Class<T> serviceType) {
        ArrayList<Plugin<T>> result = new ArrayList<Plugin<T>>();
        for (Entry entry : this.serviceLoaderList) {
            Plugin<T> plugin = this.newPlugin(serviceType, entry);
            result.add(plugin);
        }
        return result;
    }

    private <T> Plugin<T> newPlugin(Class<T> serviceType, Entry entry) {
        URL pluginURL = entry.getURL();
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType, entry.getClassLoader());
        List<T> pluginList = JarPluginLoader.toList(serviceLoader, serviceType);
        JarFile jarFile = this.createJarFile(entry.getFile());
        String pluginPackages = JarFileUtils.getManifestValue((JarFile)jarFile, (String)"Pinpoint-Plugin-Package", (String)"com.navercorp.pinpoint.plugin");
        List pluginPackageList = StringUtils.tokenizeToStringList((String)pluginPackages, (String)",");
        return new JarPlugin(pluginURL, jarFile, pluginList, pluginPackageList);
    }

    private JarFile createJarFile(File pluginJar) {
        try {
            return new JarFile(pluginJar);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error. " + e.getCause(), e);
        }
    }

    public static class Entry {
        private final URL filePath;
        private final File file;
        private final ClassLoader classLoader;

        public Entry(URL filePath, File file, ClassLoader classLoader) {
            this.filePath = (URL)Assert.requireNonNull((Object)filePath, (String)"filePath must not be null");
            this.file = (File)Assert.requireNonNull((Object)file, (String)"file must not be null");
            this.classLoader = (ClassLoader)Assert.requireNonNull((Object)classLoader, (String)"classLoader must not be null");
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getURL() {
            return this.filePath;
        }

        public File getFile() {
            return this.file;
        }
    }
}

