/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.profiler.context.CallStack;
import java.lang.reflect.Array;
import java.util.Arrays;

public class DefaultCallStack<T>
implements CallStack<T> {
    protected static final int STACK_SIZE = 8;
    protected static final int DEFAULT_INDEX = 0;
    protected final CallStack.Factory<T> factory;
    protected T[] stack;
    protected final int maxDepth;
    protected int index = 0;
    protected int overflowIndex = 0;
    protected short sequence;

    public DefaultCallStack(CallStack.Factory<T> factory) {
        this(factory, -1);
    }

    public DefaultCallStack(CallStack.Factory<T> factory, int maxDepth) {
        this.factory = factory;
        this.maxDepth = maxDepth;
        this.stack = this.newStack(factory.getType(), 8);
    }

    private T[] newStack(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    @Override
    public int getIndex() {
        if (this.isOverflow()) {
            return this.index + this.overflowIndex;
        }
        return this.index;
    }

    @Override
    public int push(T element) {
        if (this.isOverflow()) {
            ++this.overflowIndex;
            return this.index + this.overflowIndex;
        }
        this.checkExtend(this.index + 1);
        short s = this.sequence;
        this.sequence = (short)(s + 1);
        this.factory.setSequence(element, s);
        this.stack[this.index++] = element;
        this.markDepth(element, this.index);
        return this.index;
    }

    protected void markDepth(T element, int index) {
        this.factory.markDepth(element, index);
    }

    private void checkExtend(int size) {
        T[] originalStack = this.stack;
        if (size >= originalStack.length) {
            int copyStackSize = originalStack.length << 1;
            T[] copyStack = this.newStack(this.factory.getType(), copyStackSize);
            System.arraycopy(originalStack, 0, copyStack, 0, originalStack.length);
            this.stack = copyStack;
        }
    }

    @Override
    public T pop() {
        if (this.isOverflow() && this.overflowIndex > 0) {
            --this.overflowIndex;
            return this.factory.dummyInstance();
        }
        T spanEvent = this.peek();
        if (spanEvent != null) {
            this.stack[this.index - 1] = null;
            --this.index;
        }
        return spanEvent;
    }

    @Override
    public T peek() {
        if (this.index == 0) {
            return null;
        }
        if (this.isOverflow() && this.overflowIndex > 0) {
            return this.factory.dummyInstance();
        }
        return this.stack[this.index - 1];
    }

    @Override
    public boolean empty() {
        return this.index == 0;
    }

    @Override
    public T[] copyStackFrame() {
        T[] currentStack = this.stack;
        T[] copyStack = this.newStack(this.factory.getType(), currentStack.length);
        System.arraycopy(currentStack, 0, copyStack, 0, currentStack.length);
        return copyStack;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @VisibleForTesting
    boolean isOverflow() {
        return this.maxDepth != -1 && this.maxDepth < this.index;
    }

    @Override
    public CallStack.Factory<T> getFactory() {
        return this.factory;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{stack=");
        builder.append(Arrays.toString(this.stack));
        builder.append(", index=");
        builder.append(this.index);
        builder.append(", factory=");
        builder.append(this.factory);
        builder.append("}");
        return builder.toString();
    }
}

