/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.junit4;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.test.ListenableDataSender;
import com.navercorp.pinpoint.test.TBaseRecorder;
import com.navercorp.pinpoint.test.junit4.PinpointJUnit4ClassRunner;
import com.navercorp.pinpoint.test.junit4.TestContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.runner.RunWith;

@RunWith(value=PinpointJUnit4ClassRunner.class)
public abstract class BasePinpointTest {
    private volatile TBaseRecorder<?> tBaseRecorder;
    private volatile ServerMetaDataRegistryService serverMetaDataRegistryService;

    protected List<SpanEvent> getCurrentSpanEvents() {
        ArrayList<SpanEvent> spanEvents = new ArrayList<SpanEvent>();
        for (Object value : this.tBaseRecorder) {
            if (!(value instanceof SpanChunk)) continue;
            SpanChunk spanChunk = (SpanChunk)value;
            Iterator i$ = spanChunk.getSpanEventList().iterator();
            while (i$.hasNext()) {
                SpanEvent tSpanEvent;
                SpanEvent spanEvent = tSpanEvent = (SpanEvent)i$.next();
                spanEvents.add(spanEvent);
            }
        }
        return spanEvents;
    }

    protected List<Span> getCurrentRootSpans() {
        ArrayList<Span> rootSpans = new ArrayList<Span>();
        for (Object value : this.tBaseRecorder) {
            if (!(value instanceof Span)) continue;
            Span span = (Span)value;
            rootSpans.add(span);
        }
        return rootSpans;
    }

    protected ServerMetaData getServerMetaData() {
        return this.serverMetaDataRegistryService.getServerMetaData();
    }

    private void setTBaseRecorder(TBaseRecorder tBaseRecorder) {
        this.tBaseRecorder = tBaseRecorder;
    }

    private void setServerMetaDataRegistryService(ServerMetaDataRegistryService serverMetaDataRegistryService) {
        this.serverMetaDataRegistryService = serverMetaDataRegistryService;
    }

    public void setup(TestContext testContext) {
        DefaultApplicationContext mockApplicationContext = testContext.getDefaultApplicationContext();
        DataSender spanDataSender = mockApplicationContext.getSpanDataSender();
        if (spanDataSender instanceof ListenableDataSender) {
            ListenableDataSender listenableDataSender = (ListenableDataSender)spanDataSender;
            final TBaseRecorder tBaseRecord = new TBaseRecorder();
            listenableDataSender.setListener(new ListenableDataSender.Listener(){

                public boolean handleSend(Object data) {
                    return tBaseRecord.add(data);
                }
            });
            this.setTBaseRecorder(tBaseRecord);
        }
        ServerMetaDataRegistryService serverMetaDataRegistryService = mockApplicationContext.getServerMetaDataRegistryService();
        this.setServerMetaDataRegistryService(serverMetaDataRegistryService);
    }
}

