/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.client;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import com.navercorp.pinpoint.plugin.thrift.ThriftRequestProperty;
import com.navercorp.pinpoint.plugin.thrift.ThriftUtils;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor;
import com.navercorp.pinpoint.plugin.thrift.field.getter.UrlFieldGetter;
import java.net.Socket;
import java.net.URL;
import org.apache.thrift.TBase;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;

public class TServiceClientSendBaseInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope scope;
    private final boolean traceServiceArgs;

    public TServiceClientSendBaseInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope, boolean traceServiceArgs) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
        this.traceServiceArgs = traceServiceArgs;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (target instanceof TServiceClient) {
            TServiceClient client = (TServiceClient)target;
            TProtocol oprot = client.getOutputProtocol();
            TTransport transport = oprot.getTransport();
            Trace trace = this.traceContext.currentRawTraceObject();
            if (trace == null) {
                return;
            }
            boolean shouldSample = trace.canSampled();
            if (!shouldSample) {
                if (transport instanceof THttpClient) {
                    return;
                }
                ThriftRequestProperty parentTraceInfo = new ThriftRequestProperty();
                if (this.isDebug) {
                    this.logger.debug("set Sampling flag=false");
                }
                parentTraceInfo.setShouldSample(false);
                InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
                currentTransaction.setAttachment((Object)parentTraceInfo);
                return;
            }
            SpanEventRecorder recorder = trace.traceBlockBegin();
            String remoteAddress = "Unknown";
            if (transport instanceof THttpClient) {
                recorder.recordServiceType(ThriftConstants.THRIFT_CLIENT_INTERNAL);
                remoteAddress = this.getRemoteAddressForTHttpClient((THttpClient)transport);
            } else {
                recorder.recordServiceType(ThriftConstants.THRIFT_CLIENT);
                remoteAddress = this.getRemoteAddress(transport);
                recorder.recordDestinationId(remoteAddress);
                TraceId nextId = trace.getTraceId().getNextTraceId();
                recorder.recordNextSpanId(nextId.getSpanId());
                ThriftRequestProperty parentTraceInfo = new ThriftRequestProperty();
                parentTraceInfo.setTraceId(nextId.getTransactionId());
                parentTraceInfo.setSpanId(nextId.getSpanId());
                parentTraceInfo.setParentSpanId(nextId.getParentSpanId());
                parentTraceInfo.setFlags(nextId.getFlags());
                parentTraceInfo.setParentApplicationName(this.traceContext.getApplicationName());
                parentTraceInfo.setParentApplicationType(this.traceContext.getServerTypeCode());
                parentTraceInfo.setAcceptorHost(remoteAddress);
                InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
                currentTransaction.setAttachment((Object)parentTraceInfo);
            }
            String methodName = "unknown";
            if (args[0] instanceof String) {
                methodName = (String)args[0];
            }
            String serviceName = ThriftUtils.getClientServiceName(client);
            String thriftUrl = this.getServiceUrl(remoteAddress, serviceName, methodName);
            recorder.recordAttribute(ThriftConstants.THRIFT_URL, thriftUrl);
        }
    }

    private String getRemoteAddressForTHttpClient(THttpClient tHttpClient) {
        if (tHttpClient instanceof UrlFieldGetter) {
            URL url = ((UrlFieldGetter)tHttpClient)._$PINPOINT$_getUrl();
            if (url == null) {
                return "Unknown";
            }
            return HostAndPort.toHostAndPortString((String)url.getHost(), (int)url.getPort());
        }
        if (this.isDebug) {
            this.logger.debug("Invalid oprot transport object. Need field getter({}).", (Object)UrlFieldGetter.class.getName());
        }
        return "Unknown";
    }

    private String getRemoteAddress(TTransport transport) {
        if (transport instanceof SocketFieldAccessor) {
            Socket socket = ((SocketFieldAccessor)transport)._$PINPOINT$_getSocket();
            if (socket == null) {
                return "Unknown";
            }
            return ThriftUtils.getHostPort(socket.getRemoteSocketAddress());
        }
        if (this.isDebug) {
            this.logger.debug("Invalid oprot transport object. Need field accessor({}).", (Object)SocketFieldAccessor.class.getName());
        }
        return "Unknown";
    }

    private String getServiceUrl(String url, String serviceName, String methodName) {
        StringBuilder sb = new StringBuilder();
        sb.append(url).append("/").append(serviceName).append("/").append(methodName);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (this.traceServiceArgs && args.length == 2 && args[1] instanceof TBase) {
                recorder.recordAttribute(ThriftConstants.THRIFT_ARGS, this.getMethodArgs((TBase)args[1]));
            }
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getMethodArgs(TBase<?, ?> args) {
        return StringUtils.abbreviate((String)args.toString(), (int)256);
    }
}

