/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.dubbo.interceptor;

import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanRecursiveAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.dubbo.DubboConstants;
import com.navercorp.pinpoint.plugin.dubbo.DubboProviderMethodDescriptor;

public class DubboProviderInterceptor
extends SpanRecursiveAroundInterceptor {
    private static final String SCOPE_NAME = "##DUBBO_PROVIDER_TRACE";
    private static final MethodDescriptor DUBBO_PROVIDER_METHOD_DESCRIPTOR = new DubboProviderMethodDescriptor();

    public DubboProviderInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor, SCOPE_NAME);
        traceContext.cacheApi(DUBBO_PROVIDER_METHOD_DESCRIPTOR);
    }

    protected Trace createTrace(Object target, Object[] args) {
        Trace trace = this.readRequestTrace(target, args);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(DubboConstants.DUBBO_PROVIDER_SERVICE_TYPE);
            recorder.recordApi(DUBBO_PROVIDER_METHOD_DESCRIPTOR);
            this.recordRequest(recorder, target, args);
        }
        return trace;
    }

    private Trace readRequestTrace(Object target, Object[] args) {
        Invoker invoker = (Invoker)target;
        if ("com.alibaba.dubbo.monitor.MonitorService".equals(invoker.getInterface().getName())) {
            return this.traceContext.disableSampling();
        }
        RpcInvocation invocation = (RpcInvocation)args[0];
        if (invocation.getAttachment("_DUBBO_DO_NOT_TRACE") != null) {
            return this.traceContext.disableSampling();
        }
        String transactionId = invocation.getAttachment("_DUBBO_TRASACTION_ID");
        if (transactionId == null) {
            return this.traceContext.newTraceObject();
        }
        long parentSpanID = NumberUtils.parseLong((String)invocation.getAttachment("_DUBBO_PARENT_SPAN_ID"), (long)-1L);
        long spanID = NumberUtils.parseLong((String)invocation.getAttachment("_DUBBO_SPAN_ID"), (long)-1L);
        short flags = NumberUtils.parseShort((String)invocation.getAttachment("_DUBBO_FLAGS"), (short)0);
        TraceId traceId = this.traceContext.createTraceId(transactionId, parentSpanID, spanID, flags);
        return this.traceContext.continueTraceObject(traceId);
    }

    private void recordRequest(SpanRecorder recorder, Object target, Object[] args) {
        String parentApplicationName;
        RpcInvocation invocation = (RpcInvocation)args[0];
        RpcContext rpcContext = RpcContext.getContext();
        recorder.recordRpcName(invocation.getInvoker().getInterface().getSimpleName() + ":" + invocation.getMethodName());
        recorder.recordEndPoint(rpcContext.getLocalAddressString());
        if (rpcContext.getRemoteHost() != null) {
            recorder.recordRemoteAddress(rpcContext.getRemoteAddressString());
        } else {
            recorder.recordRemoteAddress("Unknown");
        }
        if (!recorder.isRoot() && (parentApplicationName = invocation.getAttachment("_DUBBO_PARENT_APPLICATION_NAME")) != null) {
            short parentApplicationType = NumberUtils.parseShort((String)invocation.getAttachment("_DUBBO_PARENT_APPLICATION_TYPE"), (short)ServiceType.UNDEFINED.getCode());
            recorder.recordParentApplication(parentApplicationName, parentApplicationType);
            String host = invocation.getAttachment("_DUBBO_HOST");
            if (host != null) {
                recorder.recordAcceptorHost(host);
            } else {
                String estimatedLocalHost = this.getLocalHost(rpcContext);
                if (estimatedLocalHost != null) {
                    recorder.recordAcceptorHost(estimatedLocalHost);
                }
            }
        }
    }

    private String getLocalHost(RpcContext rpcContext) {
        return rpcContext.getLocalAddressString();
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        RpcInvocation invocation = (RpcInvocation)args[0];
        recorder.recordServiceType(DubboConstants.DUBBO_PROVIDER_SERVICE_NO_STATISTICS_TYPE);
        recorder.recordApi(this.methodDescriptor);
        recorder.recordAttribute(DubboConstants.DUBBO_RPC_ANNOTATION_KEY, invocation.getInvoker().getInterface().getSimpleName() + ":" + invocation.getMethodName());
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        RpcInvocation invocation = (RpcInvocation)args[0];
        recorder.recordApi(this.methodDescriptor);
        recorder.recordAttribute(DubboConstants.DUBBO_ARGS_ANNOTATION_KEY, (Object)invocation.getArguments());
        if (throwable == null) {
            recorder.recordAttribute(DubboConstants.DUBBO_RESULT_ANNOTATION_KEY, result);
        } else {
            recorder.recordException(throwable);
        }
    }
}

