/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.classloader;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.ClassNameMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.MultiClassNameMatcher;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import com.navercorp.pinpoint.test.classloader.Translator;
import com.navercorp.pinpoint.test.util.BytecodeUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTranslator
implements Translator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, MatchableClassFileTransformer> transformerMap = new ConcurrentHashMap<String, MatchableClassFileTransformer>();
    private final ClassLoader loader;
    private final ClassFileTransformer dispatcher;

    public DefaultTranslator(ClassLoader loader, ClassFileTransformer defaultTransformer) {
        if (defaultTransformer == null) {
            throw new NullPointerException("dispatcher must not be null");
        }
        this.loader = loader;
        this.dispatcher = defaultTransformer;
    }

    @Override
    public void addTransformer(MatchableClassFileTransformer transformer) {
        Matcher matcher = transformer.getMatcher();
        if (matcher instanceof ClassNameMatcher) {
            ClassNameMatcher classNameMatcher = (ClassNameMatcher)matcher;
            String className = classNameMatcher.getClassName();
            this.addTransformer0(transformer, className);
        } else if (matcher instanceof MultiClassNameMatcher) {
            MultiClassNameMatcher classNameMatcher = (MultiClassNameMatcher)matcher;
            List classNameList = classNameMatcher.getClassNames();
            for (String className : classNameList) {
                this.addTransformer0(transformer, className);
            }
        } else {
            throw new IllegalArgumentException("unsupported Matcher " + matcher);
        }
    }

    private void addTransformer0(MatchableClassFileTransformer transformer, String className) {
        String checkClassInternalName = JavaAssistUtils.javaNameToJvmName((String)className);
        MatchableClassFileTransformer old = this.transformerMap.put(checkClassInternalName, transformer);
        if (old != null) {
            throw new IllegalStateException("Modifier already exist new:" + transformer.getClass() + " old:" + old.getMatcher());
        }
    }

    @Override
    public void start() {
    }

    @Override
    public byte[] transform(String className) {
        this.logger.debug("loading className:{}", (Object)className);
        String classInternalName = JavaAssistUtils.javaNameToJvmName((String)className);
        try {
            byte[] transformBytes = this.dispatcher.transform(this.loader, classInternalName, null, null, null);
            if (transformBytes != null) {
                return transformBytes;
            }
            byte[] customTransformBytes = this.customTransformer(classInternalName);
            if (customTransformBytes != null) {
                return customTransformBytes;
            }
            byte[] classFile = BytecodeUtils.getClassFile(this.loader, className);
            if (classFile == null) {
                throw new ClassNotFoundException(className + " not found");
            }
            return classFile;
        }
        catch (Throwable th) {
            throw new RuntimeException(className + " transform fail", th);
        }
    }

    private byte[] customTransformer(String jvmClassName) {
        this.logger.info("Modify find classname:{}, loader:{}", (Object)jvmClassName, (Object)this.loader);
        MatchableClassFileTransformer transformer = (MatchableClassFileTransformer)this.transformerMap.get(jvmClassName);
        if (transformer == null) {
            return null;
        }
        this.logger.info("Modify jvmClassName:{},  modifier{}, loader:{}", new Object[]{jvmClassName, transformer, this.loader});
        Thread thread = Thread.currentThread();
        ClassLoader beforeClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            byte[] transformBytes;
            String javaClassName = JavaAssistUtils.jvmNameToJavaName((String)jvmClassName);
            byte[] byArray = transformBytes = transformer.transform(this.loader, javaClassName, null, null, null);
            return byArray;
        }
        catch (IllegalClassFormatException e) {
            throw new RuntimeException(jvmClassName + " transform fail", e);
        }
        finally {
            thread.setContextClassLoader(beforeClassLoader);
        }
    }
}

