/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.module;

public final class ModuleLogger {
    private final String loggerName;
    private final int prefixSize;

    public static ModuleLogger getLogger(String loggerName) {
        return new ModuleLogger(loggerName);
    }

    private ModuleLogger(String loggerName) {
        this.loggerName = loggerName;
        this.prefixSize = this.getLength(loggerName) + 3;
    }

    public void info(String log) {
        StringBuilder sb = new StringBuilder(this.getLength(log) + this.prefixSize);
        sb.append('[');
        sb.append(this.loggerName);
        sb.append("] ");
        sb.append(log);
        System.out.println(sb.toString());
    }

    private int getLength(String log) {
        if (log == null) {
            return 4;
        }
        return log.length();
    }
}

