/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertowservlet.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.undertowservlet.UndertowAsyncListener;
import com.navercorp.pinpoint.plugin.undertowservlet.UndertowServletConstants;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestImplStartAsyncInterceptor
implements AroundInterceptor {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public HttpServletRequestImplStartAsyncInterceptor(TraceContext context, MethodDescriptor descriptor) {
        this.traceContext = context;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (this.validate(target, result, throwable)) {
                AsyncContext asyncContext = (AsyncContext)result;
                UndertowAsyncListener asyncListener = new UndertowAsyncListener(this.traceContext, recorder.recordNextAsyncContext(true));
                asyncContext.addListener((AsyncListener)asyncListener);
                if (this.isDebug) {
                    this.logger.debug("Add async listener {}", (Object)asyncListener);
                }
            }
            recorder.recordServiceType(UndertowServletConstants.UNDERTOW_SERVLET_METHOD);
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to AFTER process. {}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object target, Object result, Throwable throwable) {
        if (throwable != null || result == null) {
            return false;
        }
        if (!(target instanceof HttpServletRequest)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object, The javax.servlet.http.HttpServletRequest interface is not implemented. target={}", target);
            }
            return false;
        }
        if (!(result instanceof AsyncContext)) {
            if (this.isDebug) {
                this.logger.debug("Invalid result object, The javax.servlet.AsyncContext interface is not implemented. result={}.", result);
            }
            return false;
        }
        return true;
    }
}

