/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v3;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpPluginConfig;
import java.security.ProtectionDomain;

public class OkHttpPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        OkHttpPluginConfig config = new OkHttpPluginConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("Disable OkHttpPlugin 3.x");
            return;
        }
        this.logger.info("Setup OkHttpPlugin 3.x");
        this.addRealCall();
        this.addDispatcher();
        if (config.isAsync()) {
            this.addAsyncCall();
        }
        this.addBridegInterceptor();
        this.addRequestBuilder();
        this.addRealConnection();
        this.addHttpEngine(config);
    }

    private void addRealCall() {
        this.transformTemplate.transform("okhttp3.RealCall", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"execute", "enqueue", "cancel"}))) {
                    method.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{OkHttpConstants.OK_HTTP_CLIENT_INTERNAL}), "CallScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addDispatcher() {
        this.transformTemplate.transform("okhttp3.Dispatcher", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"execute", "cancel"}))) {
                    method.addInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{OkHttpConstants.OK_HTTP_CLIENT_INTERNAL}));
                }
                InstrumentMethod enqueueMethod = target.getDeclaredMethod("enqueue", new String[]{"okhttp3.RealCall$AsyncCall"});
                if (enqueueMethod != null) {
                    enqueueMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.interceptor.DispatcherEnqueueMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addAsyncCall() {
        this.transformTemplate.transform("okhttp3.RealCall$AsyncCall", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod executeMethod = target.getDeclaredMethod("execute", new String[0]);
                if (executeMethod != null) {
                    target.addField(AsyncContextAccessor.class.getName());
                    executeMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.interceptor.AsyncCallExecuteMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpEngine(final OkHttpPluginConfig config) {
        this.transformTemplate.transform("okhttp3.internal.http.HttpEngine", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod readResponseMethod;
                InstrumentMethod connectMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v3.UserRequestGetter", "userRequest");
                target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v3.UserResponseGetter", "userResponse");
                InstrumentMethod sendRequestMethod = target.getDeclaredMethod("sendRequest", new String[0]);
                if (sendRequestMethod != null) {
                    sendRequestMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.HttpEngineSendRequestMethodInterceptor", "SendRequestScope");
                }
                if ((connectMethod = target.getDeclaredMethod("connect", new String[0])) != null) {
                    connectMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.HttpEngineConnectMethodInterceptor");
                }
                if ((readResponseMethod = target.getDeclaredMethod("readResponse", new String[0])) != null) {
                    readResponseMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.HttpEngineReadResponseMethodInterceptor", VarArgs.va((Object[])new Object[]{config.isStatusCode()}));
                }
                return target.toBytecode();
            }
        });
    }

    private void addBridegInterceptor() {
        this.transformTemplate.transform("okhttp3.internal.http.BridgeInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod proceedMethod = target.getDeclaredMethod("intercept", new String[]{"okhttp3.Interceptor$Chain"});
                if (proceedMethod != null) {
                    proceedMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.BridgeInterceptorInterceptMethodInterceptor", "SendRequestScope", ExecutionPolicy.ALWAYS);
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequestBuilder() {
        this.transformTemplate.transform("okhttp3.Request$Builder", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod buildMethod = target.getDeclaredMethod("build", new String[0]);
                if (buildMethod != null) {
                    target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v3.HttpUrlGetter", "url");
                    buildMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.RequestBuilderBuildMethodInterceptor", "SendRequestScope", ExecutionPolicy.INTERNAL);
                }
                return target.toBytecode();
            }
        });
    }

    private void addRealConnection() {
        this.transformTemplate.transform("okhttp3.internal.connection.RealConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod connectMethod4;
                InstrumentMethod connectMethod3;
                InstrumentMethod connectMethod2;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                boolean addRouteGetter = false;
                InstrumentMethod connectMethod1 = target.getDeclaredMethod("connect", new String[]{"int", "int", "int", "java.util.List", "boolean"});
                if (connectMethod1 != null) {
                    connectMethod1.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.RealConnectionConnectMethodInterceptor");
                    addRouteGetter = true;
                }
                if ((connectMethod2 = target.getDeclaredMethod("connect", new String[]{"int", "int", "int", "boolean"})) != null) {
                    connectMethod2.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.RealConnectionConnectMethodInterceptor");
                    addRouteGetter = true;
                }
                if ((connectMethod3 = target.getDeclaredMethod("connect", new String[]{"int", "int", "int", "boolean", "okhttp3.Call", "okhttp3.EventListener"})) != null) {
                    connectMethod3.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.RealConnectionConnectMethodInterceptor");
                    addRouteGetter = true;
                }
                if ((connectMethod4 = target.getDeclaredMethod("connect", new String[]{"int", "int", "int", "int", "boolean", "okhttp3.Call", "okhttp3.EventListener"})) != null) {
                    connectMethod4.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v3.interceptor.RealConnectionConnectMethodInterceptor");
                    addRouteGetter = true;
                }
                if (addRouteGetter) {
                    target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v3.RouteGetter", "route");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

