/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedStorage
implements Storage {
    private static final Logger logger = LoggerFactory.getLogger(BufferedStorage.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private static final int DEFAULT_BUFFER_SIZE = 20;
    private final int bufferSize;
    private final TraceRoot traceRoot;
    private List<SpanEvent> storage;
    private final DataSender<Object> dataSender;

    public BufferedStorage(TraceRoot traceRoot, DataSender<Object> dataSender, int bufferSize) {
        this.traceRoot = (TraceRoot)Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        this.dataSender = (DataSender)Assert.requireNonNull(dataSender, (String)"dataSender must not be null");
        this.bufferSize = bufferSize;
        this.storage = this.allocateBuffer();
    }

    @Override
    public void store(SpanEvent spanEvent) {
        List<SpanEvent> storage = this.getBuffer();
        storage.add(spanEvent);
        if (this.overflow(storage)) {
            List<SpanEvent> flushData = this.clearBuffer();
            SpanChunk spanChunk = this.wrapSpanCHunk(flushData);
            boolean success = this.dataSender.send(spanChunk);
            if (isDebug) {
                this.flushLog(success, spanChunk);
            }
        }
    }

    private boolean overflow(List<SpanEvent> storage) {
        return storage.size() >= this.bufferSize;
    }

    private List<SpanEvent> allocateBuffer() {
        return new ArrayList<SpanEvent>(this.bufferSize);
    }

    private List<SpanEvent> getBuffer() {
        List<SpanEvent> copy = this.storage;
        if (copy == null) {
            this.storage = copy = this.allocateBuffer();
        }
        return copy;
    }

    private List<SpanEvent> clearBuffer() {
        List<SpanEvent> copy = this.storage;
        this.storage = null;
        return copy;
    }

    @Override
    public void store(Span span) {
        List<SpanEvent> spanEventList = this.clearBuffer();
        span.setSpanEventList(spanEventList);
        span.finish();
        boolean success = this.dataSender.send(span);
        if (isDebug) {
            this.flushLog(success, span);
        }
    }

    @Override
    public void flush() {
        List<SpanEvent> spanEventList = this.clearBuffer();
        if (CollectionUtils.hasLength(spanEventList)) {
            SpanChunk spanChunk = this.wrapSpanCHunk(spanEventList);
            boolean success = this.dataSender.send(spanChunk);
            if (isDebug) {
                this.flushLog(success, spanChunk);
            }
        }
    }

    private void flushLog(boolean success, Object message) {
        if (success) {
            logger.debug("Flush {}", message);
        } else {
            logger.debug("Flush fail {}", message);
        }
    }

    private SpanChunk wrapSpanCHunk(List<SpanEvent> spanEventList) {
        SpanChunk spanChunk = new SpanChunk(this.traceRoot, spanEventList);
        return spanChunk;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "BufferedStorage{bufferSize=" + this.bufferSize + ", dataSender=" + this.dataSender + '}';
    }
}

