/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistry;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.DefaultMethodDescriptor;
import com.navercorp.pinpoint.profiler.instrument.ASMClass;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.ScopeInfo;
import com.navercorp.pinpoint.profiler.instrument.interceptor.CaptureType;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import com.navercorp.pinpoint.profiler.interceptor.factory.AnnotatedInterceptorFactory;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMMethod
implements InstrumentMethod {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final EngineComponent engineComponent;
    private final InstrumentContext pluginContext;
    private final ASMClass declaringClass;
    private final ASMMethodNodeAdapter methodNode;
    private final MethodDescriptor descriptor;

    public ASMMethod(EngineComponent engineComponent, InstrumentContext pluginContext, ASMClass declaringClass, MethodNode methodNode) {
        this(engineComponent, pluginContext, declaringClass, new ASMMethodNodeAdapter(JavaAssistUtils.javaNameToJvmName(declaringClass.getName()), methodNode));
    }

    public ASMMethod(EngineComponent engineComponent, InstrumentContext pluginContext, ASMClass declaringClass, ASMMethodNodeAdapter methodNode) {
        this.engineComponent = (EngineComponent)Assert.requireNonNull((Object)engineComponent, (String)"engineComponent must not be null");
        this.pluginContext = (InstrumentContext)Assert.requireNonNull((Object)pluginContext, (String)"pluginContext must not be null");
        this.declaringClass = declaringClass;
        this.methodNode = methodNode;
        String[] parameterVariableNames = this.methodNode.getParameterNames();
        int lineNumber = this.methodNode.getLineNumber();
        DefaultMethodDescriptor descriptor = new DefaultMethodDescriptor(declaringClass.getName(), methodNode.getName(), this.getParameterTypes(), parameterVariableNames);
        descriptor.setLineNumber(lineNumber);
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.methodNode.getName();
    }

    public String[] getParameterTypes() {
        return this.methodNode.getParameterTypes();
    }

    public String getReturnType() {
        return this.methodNode.getReturnType();
    }

    public int getModifiers() {
        return this.methodNode.getAccess();
    }

    public boolean isConstructor() {
        return this.methodNode.isConstructor();
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int addInterceptor(String interceptorClassName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        return this.addInterceptor0(interceptorClassName, null, null, null);
    }

    public int addInterceptor(String interceptorClassName, Object[] constructorArgs) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, null, null);
    }

    public int addScopedInterceptor(String interceptorClassName, String scopeName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, null, interceptorScope, null);
    }

    public int addScopedInterceptor(String interceptorClassName, InterceptorScope scope) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        return this.addInterceptor0(interceptorClassName, null, scope, null);
    }

    public int addScopedInterceptor(String interceptorClassName, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addInterceptor0(interceptorClassName, null, scope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, String scopeName) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, constructorArgs, interceptorScope, null);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, scope, null);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scopeName, (String)"scopeName must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClassName, constructorArgs, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Assert.requireNonNull((Object)interceptorClassName, (String)"interceptorClassName must not be null");
        Assert.requireNonNull((Object)constructorArgs, (String)"constructorArgs must not be null");
        Assert.requireNonNull((Object)scope, (String)"scope must not be null");
        Assert.requireNonNull((Object)executionPolicy, (String)"executionPolicy must not be null");
        return this.addInterceptor0(interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    public void addInterceptor(int interceptorId) throws InstrumentException {
        Interceptor interceptor = InterceptorRegistry.getInterceptor((int)interceptorId);
        try {
            this.addInterceptor0(interceptor, interceptorId);
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add interceptor " + interceptor.getClass().getName() + " to " + this.methodNode.getLongName(), (Throwable)e);
        }
    }

    int addInterceptorInternal(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        if (interceptorClassName == null) {
            throw new NullPointerException("interceptorClassName must not be null");
        }
        return this.addInterceptor0(interceptorClassName, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(String interceptorClassName, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        ClassLoader classLoader = this.declaringClass.getClassLoader();
        ScopeFactory scopeFactory = this.engineComponent.getScopeFactory();
        ScopeInfo scopeInfo = scopeFactory.newScopeInfo(classLoader, this.pluginContext, interceptorClassName, scope, executionPolicy);
        Interceptor interceptor = this.createInterceptor(classLoader, interceptorClassName, scopeInfo, constructorArgs);
        int interceptorId = this.engineComponent.addInterceptor(interceptor);
        this.addInterceptor0(interceptor, interceptorId);
        return interceptorId;
    }

    private Interceptor createInterceptor(ClassLoader classLoader, String interceptorClassName, ScopeInfo scopeInfo, Object[] constructorArgs) {
        ObjectBinderFactory objectBinderFactory = this.engineComponent.getObjectBinderFactory();
        AnnotatedInterceptorFactory factory = objectBinderFactory.newAnnotatedInterceptorFactory(this.pluginContext);
        Interceptor interceptor = factory.getInterceptor(classLoader, interceptorClassName, constructorArgs, scopeInfo, this.declaringClass, this);
        return interceptor;
    }

    private void addInterceptor0(Interceptor interceptor, int interceptorId) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor must not be null");
        }
        InterceptorDefinition interceptorDefinition = this.engineComponent.createInterceptorDefinition(interceptor.getClass());
        Class<? extends Interceptor> interceptorClass = interceptorDefinition.getInterceptorClass();
        CaptureType captureType = interceptorDefinition.getCaptureType();
        if (this.methodNode.hasInterceptor()) {
            this.logger.warn("Skip adding interceptor. 'already intercepted method' class={}, interceptor={}", (Object)this.declaringClass.getName(), (Object)interceptorClass.getName());
            return;
        }
        if (this.methodNode.isAbstract() || this.methodNode.isNative()) {
            this.logger.warn("Skip adding interceptor. 'abstract or native method' class={}, interceptor={}", (Object)this.declaringClass.getName(), (Object)interceptorClass.getName());
            return;
        }
        int apiId = -1;
        if (interceptorDefinition.getInterceptorType() == InterceptorType.API_ID_AWARE) {
            apiId = this.engineComponent.cacheApi(this.descriptor);
        }
        if (this.isBeforeInterceptor(captureType) && interceptorDefinition.getBeforeMethod() != null) {
            this.methodNode.addBeforeInterceptor(interceptorId, interceptorDefinition, apiId);
            this.declaringClass.setModified(true);
        } else if (this.isDebug) {
            this.logger.debug("Skip adding before interceptorDefinition because the interceptorDefinition doesn't have before method: {}", (Object)interceptorClass.getName());
        }
        if (this.isAfterInterceptor(captureType) && interceptorDefinition.getAfterMethod() != null) {
            this.methodNode.addAfterInterceptor(interceptorId, interceptorDefinition, apiId);
            this.declaringClass.setModified(true);
        } else if (this.isDebug) {
            this.logger.debug("Skip adding after interceptor because the interceptor doesn't have after method: {}", (Object)interceptorClass.getName());
        }
    }

    private boolean isBeforeInterceptor(CaptureType captureType) {
        return CaptureType.BEFORE == captureType || CaptureType.AROUND == captureType;
    }

    private boolean isAfterInterceptor(CaptureType captureType) {
        return CaptureType.AFTER == captureType || CaptureType.AROUND == captureType;
    }
}

