/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.event;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSource {
    private Collection<ConfigurationListener> listeners;
    private Collection<ConfigurationErrorListener> errorListeners;
    private final Object lockDetailEventsCount = new Object();
    private int detailEvents;

    public EventSource() {
        this.initListeners();
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        EventSource.checkListener(configurationListener);
        this.listeners.add(configurationListener);
    }

    public boolean removeConfigurationListener(ConfigurationListener configurationListener) {
        return this.listeners.remove(configurationListener);
    }

    public Collection<ConfigurationListener> getConfigurationListeners() {
        return Collections.unmodifiableCollection(new ArrayList<ConfigurationListener>(this.listeners));
    }

    public void clearConfigurationListeners() {
        this.listeners.clear();
    }

    public boolean isDetailEvents() {
        return this.checkDetailEvents(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailEvents(boolean bl) {
        Object object = this.lockDetailEventsCount;
        synchronized (object) {
            this.detailEvents = bl ? ++this.detailEvents : --this.detailEvents;
        }
    }

    public void addErrorListener(ConfigurationErrorListener configurationErrorListener) {
        EventSource.checkListener(configurationErrorListener);
        this.errorListeners.add(configurationErrorListener);
    }

    public boolean removeErrorListener(ConfigurationErrorListener configurationErrorListener) {
        return this.errorListeners.remove(configurationErrorListener);
    }

    public void clearErrorListeners() {
        this.errorListeners.clear();
    }

    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return Collections.unmodifiableCollection(new ArrayList<ConfigurationErrorListener>(this.errorListeners));
    }

    protected void fireEvent(int n, String string, Object object, boolean bl) {
        Iterator<ConfigurationListener> iterator;
        if (this.checkDetailEvents(-1) && (iterator = this.listeners.iterator()).hasNext()) {
            ConfigurationEvent configurationEvent = this.createEvent(n, string, object, bl);
            while (iterator.hasNext()) {
                iterator.next().configurationChanged(configurationEvent);
            }
        }
    }

    protected ConfigurationEvent createEvent(int n, String string, Object object, boolean bl) {
        return new ConfigurationEvent(this, n, string, object, bl);
    }

    protected void fireError(int n, String string, Object object, Throwable throwable) {
        Iterator<ConfigurationErrorListener> iterator = this.errorListeners.iterator();
        if (iterator.hasNext()) {
            ConfigurationErrorEvent configurationErrorEvent = this.createErrorEvent(n, string, object, throwable);
            while (iterator.hasNext()) {
                iterator.next().configurationError(configurationErrorEvent);
            }
        }
    }

    protected ConfigurationErrorEvent createErrorEvent(int n, String string, Object object, Throwable throwable) {
        return new ConfigurationErrorEvent((Object)this, n, string, object, throwable);
    }

    protected Object clone() throws CloneNotSupportedException {
        EventSource eventSource = (EventSource)super.clone();
        eventSource.initListeners();
        return eventSource;
    }

    private static void checkListener(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
    }

    private void initListeners() {
        this.listeners = new CopyOnWriteArrayList<ConfigurationListener>();
        this.errorListeners = new CopyOnWriteArrayList<ConfigurationErrorListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDetailEvents(int n) {
        Object object = this.lockDetailEventsCount;
        synchronized (object) {
            return this.detailEvents > n;
        }
    }
}

