/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils;

import com.secnium.iast.thirdparty.org.apache.commons.beanutils.DynaBean;
import com.secnium.iast.thirdparty.org.apache.commons.beanutils.DynaClass;
import com.secnium.iast.thirdparty.org.apache.commons.beanutils.DynaProperty;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.ConfigurationDynaBean;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class ConfigurationDynaClass
implements DynaClass {
    private static final Log LOG = LogFactory.getLog(ConfigurationDynaClass.class);
    private final Configuration configuration;

    public ConfigurationDynaClass(Configuration configuration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("ConfigurationDynaClass(" + configuration + ")");
        }
        this.configuration = configuration;
    }

    public DynaProperty getDynaProperty(String string) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("getDynaProperty(" + string + ")");
        }
        if (string == null) {
            throw new IllegalArgumentException("Property name must not be null!");
        }
        Object object = this.configuration.getProperty(string);
        if (object == null) {
            return null;
        }
        Class<Object> clazz = object.getClass();
        if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        }
        if (clazz == Character.class) {
            clazz = Character.TYPE;
        } else if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        } else if (clazz == Double.class) {
            clazz = Double.TYPE;
        } else if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Long.class) {
            clazz = Long.TYPE;
        } else if (clazz == Short.class) {
            clazz = Short.TYPE;
        }
        return new DynaProperty(string, clazz);
    }

    public DynaProperty[] getDynaProperties() {
        DynaProperty[] dynaPropertyArray;
        if (LOG.isTraceEnabled()) {
            LOG.trace("getDynaProperties()");
        }
        Iterator<String> iterator = this.configuration.getKeys();
        ArrayList<DynaProperty> arrayList = new ArrayList<DynaProperty>();
        while (iterator.hasNext()) {
            dynaPropertyArray = iterator.next();
            DynaProperty dynaProperty = this.getDynaProperty((String)dynaPropertyArray);
            arrayList.add(dynaProperty);
        }
        dynaPropertyArray = new DynaProperty[arrayList.size()];
        arrayList.toArray(dynaPropertyArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + arrayList.size() + " properties.");
        }
        return dynaPropertyArray;
    }

    public String getName() {
        return ConfigurationDynaBean.class.getName();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new ConfigurationDynaBean(this.configuration);
    }
}

