#!/bin/bash

if [[ -e /.firstrun ]]; then
    /scripts/init_script.sh
fi

cd /home/quant_group/rabbitmq
touch nohup.out

echo "Starting RabbitMQ..."
nohup /usr/sbin/rabbitmq-server > /tmp/rabbitmq.out &



function wait(){
	count=1
	until [[ $count -eq 300 ]] || [[ $is_running -eq 1 ]]
	do
	  let count+=1
	  echo "count is $count"
	  curl -X GET -H "Authorization: Basic cWE6cWF0ZXN0" "http://localhost:15672/api/definitions"
  
	  if [ $? -eq 0 ]
	    then
		  	echo "rabbitmq is running rabbitmq-plugins enable rabbitmq_delayed_message_exchange"
		  	rabbitmq-plugins enable rabbitmq_delayed_message_exchange
	  
		  	tail -f /tmp/rabbitmq.out
	    else
	      echo "rabbitmq is not running"
	      sleep 1
	  fi
	done
}


function sync_config(){
	count=1
	is_running=0

	export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

	curl --request POST \
	  --url http://192.168.6.13/api/etcd/set_env_job_status \
	  --header 'Content-Type: application/json' \
	  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"pending\"}"


	until [[ $count -eq 300 ]] || [[ $is_running -eq 1 ]]
	do
	  let count+=1
	  echo "count is $count"
	  curl -X GET -H "Authorization: Basic cWE6cWF0ZXN0" "http://rabbitmq:15672/api/definitions"
  
	  if [ $? -eq 0 ]
	    then
	      echo "rabbitmq is running"
	      is_running=1
	    else
	      echo "rabbitmq is not running"
	      sleep 1
	  fi
	done

	if [[ $is_running -eq 1 ]]
	  then  
	    echo "rabbitmq is running!!! start execution sync job"
			echo "init rabbit with eos server"
			# echo "get definitions from 172.16.1.231"
			# response=$(curl -X GET -H "Authorization: Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=" "http://172.16.1.231:15672/api/definitions")
			# curl -X POST -H "Content-Type: application/json" -H "Authorization: Basic cWE6cWF0ZXN0" -d $response "http://rabbitmq:15672/api/definitions"
			response=$(curl -X POST -H "Content-Type: application/json" -d "{\"namespace\":\"$NAMESPACE\"}" "http://eos.quantgroups.com/api/etcd/init_env_rabbitmq_config")
	  	echo $response
		else
	    echo "rabbitmq is not running!!! Do not execution sync job"
	fi

	curl --request POST \
	  --url http://192.168.6.13/api/etcd/set_env_job_status \
	  --header 'Content-Type: application/json' \
	  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"done\"}"

}


wait
sync_config


