/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.jexl2.Expression;
import com.secnium.iast.thirdparty.org.apache.commons.jexl2.JexlContext;
import com.secnium.iast.thirdparty.org.apache.commons.jexl2.JexlEngine;
import com.secnium.iast.thirdparty.org.apache.commons.jexl2.MapContext;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ClassUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrLookup;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrSubstitutor;
import java.util.ArrayList;

public class ExprLookup
extends StrLookup {
    private static final String CLASS = "Class:";
    private static final String DEFAULT_PREFIX = "$[";
    private static final String DEFAULT_SUFFIX = "]";
    private AbstractConfiguration configuration;
    private final JexlEngine engine = new JexlEngine();
    private Variables variables;
    private String prefixMatcher = "$[";
    private String suffixMatcher = "]";

    public ExprLookup() {
    }

    public ExprLookup(Variables variables) {
        this.setVariables(variables);
    }

    public ExprLookup(Variables variables, String string, String string2) {
        this(variables);
        this.setVariablePrefixMatcher(string);
        this.setVariableSuffixMatcher(string2);
    }

    public void setVariablePrefixMatcher(String string) {
        this.prefixMatcher = string;
    }

    public void setVariableSuffixMatcher(String string) {
        this.suffixMatcher = string;
    }

    public void setVariables(Variables variables) {
        this.variables = new Variables(variables);
    }

    public Variables getVariables() {
        return null;
    }

    public void setConfiguration(AbstractConfiguration abstractConfiguration) {
        this.configuration = abstractConfiguration;
    }

    public String lookup(String string) {
        ConfigurationInterpolator configurationInterpolator = this.configuration.getInterpolator();
        StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)configurationInterpolator, this.prefixMatcher, this.suffixMatcher, '$');
        String string2 = strSubstitutor.replace(string);
        try {
            Expression expression = this.engine.createExpression(string2);
            string2 = (String)expression.evaluate(this.createContext());
        }
        catch (Exception exception) {
            this.configuration.getLogger().debug("Error encountered evaluating " + string2, exception);
        }
        return string2;
    }

    private JexlContext createContext() {
        MapContext mapContext = new MapContext();
        this.initializeContext((JexlContext)mapContext);
        return mapContext;
    }

    private void initializeContext(JexlContext jexlContext) {
        for (Variable variable : this.variables) {
            jexlContext.set(variable.getName(), variable.getValue());
        }
    }

    public static class Variable {
        private String key;
        private Object value;

        public Variable() {
        }

        public Variable(String string, Object object) {
            this.setName(string);
            this.setValue(object);
        }

        public String getName() {
            return this.key;
        }

        public void setName(String string) {
            this.key = string;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) throws ConfigurationRuntimeException {
            try {
                if (!(object instanceof String)) {
                    this.value = object;
                    return;
                }
                String string = (String)object;
                String string2 = StringUtils.removeStartIgnoreCase(string, ExprLookup.CLASS);
                Class clazz = ClassUtils.getClass(string2);
                this.value = string2.length() == string.length() ? clazz.newInstance() : clazz;
            }
            catch (Exception exception) {
                throw new ConfigurationRuntimeException("Unable to create " + object, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Variables
    extends ArrayList<Variable> {
        private static final long serialVersionUID = 20111205L;

        public Variables() {
        }

        public Variables(Variables variables) {
            super(variables);
        }

        public Variable getVariable() {
            if (this.size() > 0) {
                return (Variable)this.get(this.size() - 1);
            }
            return null;
        }
    }
}

