/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalReloadableConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.Reloadable;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SubnodeConfiguration
extends HierarchicalReloadableConfiguration {
    private static final long serialVersionUID = 3105734147019386480L;
    private HierarchicalConfiguration parent;
    private String subnodeKey;

    public SubnodeConfiguration(HierarchicalConfiguration hierarchicalConfiguration, ConfigurationNode configurationNode) {
        super(hierarchicalConfiguration instanceof Reloadable ? ((Reloadable)((Object)hierarchicalConfiguration)).getReloadLock() : null);
        if (hierarchicalConfiguration == null) {
            throw new IllegalArgumentException("Parent configuration must not be null!");
        }
        if (configurationNode == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.setRootNode(configurationNode);
        this.parent = hierarchicalConfiguration;
        this.initFromParent(hierarchicalConfiguration);
    }

    public HierarchicalConfiguration getParent() {
        return this.parent;
    }

    public String getSubnodeKey() {
        return this.subnodeKey;
    }

    public void setSubnodeKey(String string) {
        this.subnodeKey = string;
    }

    public ConfigurationNode getRootNode() {
        if (this.getSubnodeKey() != null) {
            try {
                List<ConfigurationNode> list = this.getParent().fetchNodeList(this.getSubnodeKey());
                if (list.size() == 1) {
                    ConfigurationNode configurationNode = list.get(0);
                    if (configurationNode != super.getRootNode()) {
                        this.fireEvent(12, null, null, true);
                        this.setRootNode(configurationNode);
                        this.fireEvent(12, null, null, false);
                    }
                    return configurationNode;
                }
                this.setSubnodeKey(null);
            }
            catch (Exception exception) {
                this.setSubnodeKey(null);
            }
        }
        return super.getRootNode();
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode configurationNode) {
        SubnodeConfiguration subnodeConfiguration = new SubnodeConfiguration(this.getParent(), configurationNode);
        this.getParent().registerSubnodeConfiguration(subnodeConfiguration);
        return subnodeConfiguration;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode configurationNode, String string) {
        SubnodeConfiguration subnodeConfiguration = this.createSubnodeConfiguration(configurationNode);
        if (this.getSubnodeKey() != null) {
            ArrayList<ConfigurationNode> arrayList = new ArrayList<ConfigurationNode>();
            ConfigurationNode configurationNode2 = super.getRootNode();
            for (ConfigurationNode configurationNode3 = configurationNode; configurationNode3 != configurationNode2; configurationNode3 = configurationNode3.getParentNode()) {
                arrayList.add(configurationNode3);
            }
            Collections.reverse(arrayList);
            String string2 = this.getSubnodeKey();
            for (ConfigurationNode configurationNode4 : arrayList) {
                string2 = this.getParent().getExpressionEngine().nodeKey(configurationNode4, string2);
            }
            subnodeConfiguration.setSubnodeKey(string2);
        }
        return subnodeConfiguration;
    }

    protected HierarchicalConfiguration.Node createNode(String string) {
        return this.getParent().createNode(string);
    }

    protected void initFromParent(HierarchicalConfiguration hierarchicalConfiguration) {
        this.setExpressionEngine(hierarchicalConfiguration.getExpressionEngine());
        this.setListDelimiter(hierarchicalConfiguration.getListDelimiter());
        this.setDelimiterParsingDisabled(hierarchicalConfiguration.isDelimiterParsingDisabled());
        this.setThrowExceptionOnMissing(hierarchicalConfiguration.isThrowExceptionOnMissing());
    }

    protected ConfigurationInterpolator createInterpolator() {
        ConfigurationInterpolator configurationInterpolator = super.createInterpolator();
        configurationInterpolator.setParentInterpolator(this.getParent().getInterpolator());
        return configurationInterpolator;
    }
}

