#!/bin/bash


if [[ -e /.firstrun ]]; then
    /scripts/init_script.sh
fi

cd /home/quant_group/rabbitmq
touch nohup.out

echo "Starting RabbitMQ..."
> /tmp/rabbitmq.out
nohup /usr/sbin/rabbitmq-server > /tmp/rabbitmq.out &


export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

count=1
is_running=0
until [[ is_running -eq 1 ]]
do
	echo "wait rabbitmq start flag"
	num=`grep -n -E 'Server startup complete' /tmp/rabbitmq.out |cut -d ":" -f 1`
	echo "----$num"
	if [ -n "$num" ];then
		is_running=1
		break
	fi
	sleep 10
done

echo "wait 5s"
sleep 5

rabbitmq-plugins enable rabbitmq_delayed_message_exchange


curl --request POST \
  --url http://192.168.6.13/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"pending\"}"


response=$(curl -X POST -H "Content-Type: application/json" -d "{\"namespace\":\"$NAMESPACE\"}" "http://192.168.6.13/api/etcd/init_env_rabbitmq_config")
echo $response


curl --request POST \
  --url http://192.168.6.13/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"done\"}"


tail -f /tmp/rabbitmq.out






