/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.v2.ConnectionGetter;
import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;

public class HttpEngineConnectMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HttpEngineConnectMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        Connection connection;
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(OkHttpConstants.OK_HTTP_CLIENT_INTERNAL);
        recorder.recordException(throwable);
        if (target instanceof ConnectionGetter && (connection = ((ConnectionGetter)target)._$PINPOINT$_getConnection()) != null) {
            String hostAndPort = this.getHostAndPort(connection);
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
        }
    }

    private String getHostAndPort(Connection connection) {
        Address address = connection.getRoute().getAddress();
        return HostAndPort.toHostAndPortString((String)address.getUriHost(), (int)address.getUriPort());
    }
}

