/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientConstants;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientPluginConfig;
import com.navercorp.pinpoint.plugin.rabbitmq.client.descriptor.RabbitMQConsumerEntryMethodDescriptor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.LocalAddressAccessor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.getter.ChannelGetter;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;
import java.util.Collections;
import java.util.Map;

public class RabbitMQConsumerDispatchInterceptor
implements AroundInterceptor {
    private static final RabbitMQConsumerEntryMethodDescriptor CONSUMER_ENTRY_METHOD_DESCRIPTOR = new RabbitMQConsumerEntryMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final Filter<String> excludeExchangeFilter;

    public RabbitMQConsumerDispatchInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, Filter<String> excludeExchangeFilter) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.excludeExchangeFilter = excludeExchangeFilter;
        this.traceContext.cacheApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        block7: {
            if (!this.validate(target, args)) {
                return;
            }
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                Trace trace = this.createTrace(target, args);
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT_INTERNAL);
                if (args[2] instanceof AsyncContextAccessor) {
                    AsyncContext asyncContext = recorder.recordNextAsyncContext();
                    ((AsyncContextAccessor)args[2])._$PINPOINT$_setAsyncContext(asyncContext);
                }
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (!this.validate(target, args)) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            this.traceContext.removeTraceObject();
            trace.traceBlockEnd();
            trace.close();
        }
    }

    private Trace createTrace(Object target, Object[] args) {
        Trace trace;
        Channel channel = ((ChannelGetter)target)._$PINPOINT$_getChannel();
        if (channel == null) {
            this.logger.debug("channel is null, skipping trace");
            return null;
        }
        Connection connection = channel.getConnection();
        if (connection == null) {
            this.logger.debug("connection is null, skipping trace");
            return null;
        }
        Envelope envelope = (Envelope)args[2];
        String exchange = envelope.getExchange();
        if (RabbitMQClientPluginConfig.isExchangeExcluded(exchange, this.excludeExchangeFilter)) {
            if (this.isDebug) {
                this.logger.debug("exchange {} is excluded", (Object)exchange);
            }
            return null;
        }
        AMQP.BasicProperties properties = (AMQP.BasicProperties)args[3];
        Map<String, Object> headers = this.getHeadersFromBasicProperties(properties);
        if (headers.get("Pinpoint-Sampled") != null) {
            return this.traceContext.disableSampling();
        }
        TraceId traceId = this.populateTraceIdFromRequest(headers);
        Trace trace2 = trace = traceId == null ? this.traceContext.newTraceObject() : this.traceContext.continueTraceObject(traceId);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.recordRootSpan(recorder, connection, envelope, headers);
        }
        return trace;
    }

    private Map<String, Object> getHeadersFromBasicProperties(AMQP.BasicProperties properties) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        Map headers = properties.getHeaders();
        if (headers == null) {
            return Collections.emptyMap();
        }
        return headers;
    }

    private TraceId populateTraceIdFromRequest(Map<String, Object> headers) {
        Object transactionId = headers.get("Pinpoint-TraceID");
        if (transactionId == null) {
            return null;
        }
        long parentSpanId = NumberUtils.parseLong((String)headers.get("Pinpoint-pSpanID").toString(), (long)-1L);
        long spanId = NumberUtils.parseLong((String)headers.get("Pinpoint-SpanID").toString(), (long)-1L);
        short flags = NumberUtils.parseShort((String)headers.get("Pinpoint-Flags").toString(), (short)0);
        return this.traceContext.createTraceId(transactionId.toString(), parentSpanId, spanId, flags);
    }

    private void recordRootSpan(SpanRecorder recorder, Connection connection, Envelope envelope, Map<String, Object> headers) {
        recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT);
        recorder.recordApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
        String endPoint = "Unknown";
        String remoteAddress = "Unknown";
        if (connection instanceof AMQConnection) {
            AMQConnection amqConnection = (AMQConnection)connection;
            FrameHandler frameHandler = amqConnection.getFrameHandler();
            if (frameHandler instanceof LocalAddressAccessor) {
                endPoint = ((LocalAddressAccessor)frameHandler)._$PINPOINT$_getLocalAddress();
            }
            if (frameHandler instanceof RemoteAddressAccessor) {
                remoteAddress = ((RemoteAddressAccessor)frameHandler)._$PINPOINT$_getRemoteAddress();
            }
        }
        recorder.recordEndPoint(endPoint);
        recorder.recordRemoteAddress(remoteAddress);
        String exchange = envelope.getExchange();
        if (StringUtils.isEmpty((String)exchange)) {
            exchange = "Unknown";
        }
        recorder.recordRpcName("rabbitmq://exchange=" + exchange);
        recorder.recordAcceptorHost("exchange-" + exchange);
        if (this.isDebug) {
            this.logger.debug("endPoint={}->{}", (Object)envelope.getExchange(), (Object)exchange);
        }
        recorder.recordAttribute(RabbitMQClientConstants.RABBITMQ_ROUTINGKEY_ANNOTATION_KEY, envelope.getRoutingKey());
        if (!MapUtils.isEmpty(headers)) {
            Object parentApplicationName = headers.get("Pinpoint-pAppName");
            if (!recorder.isRoot() && parentApplicationName != null) {
                Object parentApplicationType = headers.get("Pinpoint-pAppType");
                recorder.recordParentApplication(parentApplicationName.toString(), NumberUtils.parseShort((String)parentApplicationType.toString(), (short)ServiceType.UNDEFINED.getCode()));
            }
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length < 4) {
            return false;
        }
        if (!(target instanceof ChannelGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ChannelGetter.class.getName());
            }
            return false;
        }
        if (!(args[2] instanceof Envelope)) {
            if (this.isDebug) {
                String args2 = args[2] == null ? "null" : args[2].getClass().getName();
                this.logger.debug("Expected args[2] to be an instance of {}, but was {}", (Object)Envelope.class.getName(), (Object)args2);
            }
            return false;
        }
        if (args[3] != null && !(args[3] instanceof AMQP.BasicProperties)) {
            if (this.isDebug) {
                String args3 = args[3].getClass().getName();
                this.logger.debug("Expected args[3] to be an instance of {}, but was {}", (Object)AMQP.BasicProperties.class.getName(), (Object)args3);
            }
            return false;
        }
        return true;
    }
}

