/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matchers;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.InterfaceInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.plugin.vertx.VertxConfig;
import com.navercorp.pinpoint.plugin.vertx.VertxDetector;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpServerConfig;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

@InterfaceStability.Unstable
public class VertxPlugin
implements ProfilerPlugin,
MatchableTransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isInfo = this.logger.isInfoEnabled();
    private MatchableTransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        VertxConfig config = new VertxConfig(context.getConfig());
        if (!config.isEnable() || !config.isEnableHttpServer() && !config.isEnableHttpClient()) {
            if (this.isInfo) {
                this.logger.info("Disable VertxPlugin.");
            }
            return;
        }
        if (this.isInfo) {
            this.logger.info("Enable VertxPlugin. version range=[3.3, 3.5.0]");
        }
        VertxDetector vertxDetector = new VertxDetector(config.getBootstrapMains());
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{vertxDetector});
        List<String> basePackageNames = this.filterBasePackageNames(config.getHandlerBasePackageNames());
        if (!basePackageNames.isEmpty()) {
            this.addHandlerInterceptor(basePackageNames);
            if (this.isInfo) {
                this.logger.info("Adding Vertx Handler. base-packages={}.", config.getHandlerBasePackageNames());
            }
            this.addContextImpl("io.vertx.core.impl.ContextImpl");
            this.addContextImpl("io.vertx.core.impl.EventLoopContext");
            this.addContextImpl("io.vertx.core.impl.MultiThreadedWorkerContext");
            this.addContextImpl("io.vertx.core.impl.WorkerContext");
        }
        if (config.isEnableHttpServer()) {
            VertxHttpServerConfig serverConfig;
            String requestHandlerMethodName;
            if (this.isInfo) {
                this.logger.info("Adding Vertx HTTP Server.");
            }
            if ((requestHandlerMethodName = (serverConfig = new VertxHttpServerConfig(context.getConfig())).getRequestHandlerMethodName()) == null || requestHandlerMethodName.isEmpty()) {
                this.logger.warn("Not found 'profiler.vertx.http.server.request-handler.method.name' in config");
            } else {
                try {
                    String className = this.toClassName(requestHandlerMethodName);
                    String methodName = this.toMethodName(requestHandlerMethodName);
                    if (this.isInfo) {
                        this.logger.info("Add request handler method for Vertx HTTP Server. class={}, method={}", (Object)className, (Object)methodName);
                    }
                    this.addRequestHandlerMethod(className, methodName);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Invalid 'profiler.vertx.http.server.request-handler.method.name' value={}", (Object)requestHandlerMethodName);
                }
            }
            this.addHttpServerRequestImpl();
            this.addHttpServerResponseImpl();
        }
        if (config.isEnableHttpClient()) {
            if (this.isInfo) {
                this.logger.info("Adding Vertx HTTP Client.");
            }
            this.addHttpClientImpl();
            this.addHttpClientRequestImpl();
            this.addHttpClientStream();
            this.addHttpClientResponseImpl();
        }
    }

    List<String> filterBasePackageNames(List<String> basePackageNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (String basePackageName : basePackageNames) {
            String name = basePackageName.trim();
            if (name.isEmpty()) continue;
            list.add(name);
        }
        return list;
    }

    String toClassName(String fullQualifiedMethodName) {
        int classEndPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (classEndPosition <= 0) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(0, classEndPosition).trim();
    }

    String toMethodName(String fullQualifiedMethodName) {
        int methodBeginPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (methodBeginPosition <= 0 || methodBeginPosition + 1 >= fullQualifiedMethodName.length()) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(methodBeginPosition + 1).trim();
    }

    private void addHandlerInterceptor(List<String> basePackageNames) {
        Matcher matcher = Matchers.newPackageBasedMatcher(basePackageNames, (MatcherOperand)new InterfaceInternalNameMatcherOperand("io.vertx.core.Handler", true));
        this.transformTemplate.transform(matcher, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod handleMethod = target.getDeclaredMethod("handle", new String[]{"java.lang.Object"});
                if (handleMethod != null) {
                    handleMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HandlerInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addContextImpl(String className) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod executeBlockingMethod3;
                InstrumentMethod executeBlockingMethod2;
                InstrumentMethod executeBlockingMethod1;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod runOnContextMethod = target.getDeclaredMethod("runOnContext", new String[]{"io.vertx.core.Handler"});
                if (runOnContextMethod != null) {
                    runOnContextMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.ContextImplRunOnContextInterceptor");
                }
                if ((executeBlockingMethod1 = target.getDeclaredMethod("executeBlocking", new String[]{"io.vertx.core.impl.Action", "io.vertx.core.Handler"})) != null) {
                    executeBlockingMethod1.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.ContextImplExecuteBlockingInterceptor");
                }
                if ((executeBlockingMethod2 = target.getDeclaredMethod("executeBlocking", new String[]{"io.vertx.core.Handler", "boolean", "io.vertx.core.Handler"})) != null) {
                    executeBlockingMethod2.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.ContextImplExecuteBlockingInterceptor");
                }
                if ((executeBlockingMethod3 = target.getDeclaredMethod("executeBlocking", new String[]{"io.vertx.core.Handler", "io.vertx.core.impl.TaskQueue", "io.vertx.core.Handler"})) != null) {
                    executeBlockingMethod3.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.ContextImplExecuteBlockingInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequestHandlerMethod(String className, final String methodName) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod handleRequestMethod = target.getDeclaredMethod(methodName, new String[]{"io.vertx.core.http.HttpServerRequest"});
                if (handleRequestMethod != null) {
                    handleRequestMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.ServerConnectionHandleRequestInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpServerRequestImpl() {
        this.transformTemplate.transform("io.vertx.core.http.impl.HttpServerRequestImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod handleEndMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod handleExceptionMethod = target.getDeclaredMethod("handleException", new String[]{"java.lang.Throwable"});
                if (handleExceptionMethod != null) {
                    handleExceptionMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HandleExceptionInterceptor");
                }
                if ((handleEndMethod = target.getDeclaredMethod("handleEnd", new String[0])) != null) {
                    handleEndMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerRequestImplHandleEndInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpServerResponseImpl() {
        this.transformTemplate.transform("io.vertx.core.http.impl.HttpServerResponseImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod handleClosedMethod;
                InstrumentMethod handleExceptionMethod;
                InstrumentMethod closeMethod;
                InstrumentMethod endBufferMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod endMethod = target.getDeclaredMethod("end", new String[0]);
                if (endMethod != null) {
                    endMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                if ((endBufferMethod = target.getDeclaredMethod("end", new String[]{"io.vertx.core.buffer.Buffer"})) != null) {
                    endBufferMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                if ((closeMethod = target.getDeclaredMethod("close", new String[0])) != null) {
                    closeMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                for (InstrumentMethod sendFileMethod : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"sendFile"}))) {
                    if (sendFileMethod == null) continue;
                    sendFileMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                InstrumentMethod handleDrainedMethod = target.getDeclaredMethod("handleDrained", new String[0]);
                if (handleDrainedMethod != null) {
                    handleDrainedMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                if ((handleExceptionMethod = target.getDeclaredMethod("handleException", new String[]{"java.lang.Throwable"})) != null) {
                    handleExceptionMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HandleExceptionInterceptor");
                }
                if ((handleClosedMethod = target.getDeclaredMethod("handleClosed", new String[0])) != null) {
                    handleClosedMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerResponseImplInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpClientImpl() {
        this.transformTemplate.transform("io.vertx.core.http.impl.HttpClientImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod createRequestMethod2;
                InstrumentMethod createRequestMethod1;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"requestAbs", "request", "get", "getAbs", "getNow", "post", "postAbs", "head", "headAbs", "headNow", "options", "optionsAbs", "optionsNow", "put", "putAbs", "delete", "deleteAbs"}))) {
                    if (method == null) continue;
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientImplInterceptor", "HttpClientRequestScope");
                }
                InstrumentMethod doRequestMethod = target.getDeclaredMethod("doRequest", new String[]{"io.vertx.core.http.HttpMethod", "java.lang.String", "int", "java.lang.String", "io.vertx.core.MultiMap"});
                if (doRequestMethod != null) {
                    doRequestMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientImplDoRequestInterceptor");
                }
                if ((createRequestMethod1 = target.getDeclaredMethod("createRequest", new String[]{"io.vertx.core.http.HttpMethod", "java.lang.String", "int", "java.lang.Boolean", "java.lang.String", "io.vertx.core.MultiMap"})) != null) {
                    createRequestMethod1.addScopedInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientImplDoRequestInterceptor", "HttpClientCreateRequestScope");
                }
                if ((createRequestMethod2 = target.getDeclaredMethod("createRequest", new String[]{"io.vertx.core.http.HttpMethod", "java.lang.String", "java.lang.String", "int", "java.lang.Boolean", "java.lang.String", "io.vertx.core.MultiMap"})) != null) {
                    createRequestMethod2.addScopedInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientImplDoRequestInterceptor", "HttpClientCreateRequestScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpClientRequestImpl() {
        this.transformTemplate.transform("io.vertx.core.http.impl.HttpClientRequestImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod handleExceptionMethod;
                InstrumentMethod handleDrainedMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"doHandleResponse"}))) {
                    if (method == null) continue;
                    method.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientRequestImplDoHandleResponseInterceptor");
                }
                InstrumentMethod connectedMethod = target.getDeclaredMethod("connected", new String[]{"io.vertx.core.http.impl.HttpClientStream", "io.vertx.core.Handler"});
                if (connectedMethod != null) {
                    connectedMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientRequestImplInterceptor");
                }
                if ((handleDrainedMethod = target.getDeclaredMethod("handleDrained", new String[0])) != null) {
                    handleDrainedMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientRequestImplInterceptor");
                }
                if ((handleExceptionMethod = target.getDeclaredMethod("handleException", new String[]{"java.lang.Throwable"})) != null) {
                    handleExceptionMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HandleExceptionInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpClientStream() {
        this.transformTemplate.transform("io.vertx.core.http.impl.ClientConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod prepareHeadersMethod = target.getDeclaredMethod("prepareHeaders", new String[]{"io.netty.handler.codec.http.HttpRequest", "java.lang.String", "boolean"});
                if (prepareHeadersMethod != null) {
                    prepareHeadersMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientStreamInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpClientResponseImpl() {
        this.transformTemplate.transform("io.vertx.core.http.impl.HttpClientResponseImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod handleExceptionMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod handleEndMethod = target.getDeclaredMethod("handleEnd", new String[]{"io.vertx.core.buffer.Buffer", "io.vertx.core.MultiMap"});
                if (handleEndMethod != null) {
                    handleEndMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HttpClientResponseImplInterceptor");
                }
                if ((handleExceptionMethod = target.getDeclaredMethod("handleException", new String[]{"java.lang.Throwable"})) != null) {
                    handleExceptionMethod.addInterceptor("com.navercorp.pinpoint.plugin.vertx.interceptor.HandleExceptionInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(MatchableTransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

