/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.DefaultClientFactory;
import com.navercorp.pinpoint.profiler.context.module.MetadataConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.TcpDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.TBaseSerializer;
import org.apache.thrift.TBase;

public class TcpDataSenderProvider
implements Provider<EnhancedDataSender<Object>> {
    private final ProfilerConfig profilerConfig;
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final Provider<HeaderTBaseSerializer> tBaseSerializerProvider;
    private final MessageConverter<TBase<?, ?>> messageConverter;

    @Inject
    public TcpDataSenderProvider(ProfilerConfig profilerConfig, @DefaultClientFactory Provider<PinpointClientFactory> clientFactoryProvider, Provider<HeaderTBaseSerializer> tBaseSerializerProvider, @MetadataConverter MessageConverter<TBase<?, ?>> messageConverter) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.clientFactoryProvider = (Provider)Assert.requireNonNull(clientFactoryProvider, (String)"clientFactoryProvider must not be null");
        this.tBaseSerializerProvider = (Provider)Assert.requireNonNull(tBaseSerializerProvider, (String)"tBaseSerializerProvider must not be null");
        this.messageConverter = (MessageConverter)Assert.requireNonNull(messageConverter, (String)"messageConverter must not be null");
    }

    public EnhancedDataSender<Object> get() {
        PinpointClientFactory clientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
        String collectorTcpServerIp = this.profilerConfig.getCollectorTcpServerIp();
        int collectorTcpServerPort = this.profilerConfig.getCollectorTcpServerPort();
        HeaderTBaseSerializer headerTBaseSerializer = (HeaderTBaseSerializer)this.tBaseSerializerProvider.get();
        ThriftMessageSerializer messageSerializer = new ThriftMessageSerializer(this.messageConverter, (TBaseSerializer)headerTBaseSerializer);
        return new TcpDataSender("Default", collectorTcpServerIp, collectorTcpServerPort, clientFactory, messageSerializer);
    }
}

