/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.plist;

import com.secnium.iast.thirdparty.org.apache.commons.codec.binary.Hex;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.MapConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.ParseException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.PropertyListParser;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final DateComponentParser DATE_SEPARATOR_PARSER = new DateSeparatorParser("-");
    private static final DateComponentParser TIME_SEPARATOR_PARSER = new DateSeparatorParser(":");
    private static final DateComponentParser BLANK_SEPARATOR_PARSER = new DateSeparatorParser(" ");
    private static final DateComponentParser[] DATE_PARSERS = new DateComponentParser[]{new DateSeparatorParser("<*D"), new DateFieldParser(1, 4), DATE_SEPARATOR_PARSER, new DateFieldParser(2, 2, 1), DATE_SEPARATOR_PARSER, new DateFieldParser(5, 2), BLANK_SEPARATOR_PARSER, new DateFieldParser(11, 2), TIME_SEPARATOR_PARSER, new DateFieldParser(12, 2), TIME_SEPARATOR_PARSER, new DateFieldParser(13, 2), BLANK_SEPARATOR_PARSER, new DateTimeZoneParser(), new DateSeparatorParser(">")};
    private static final String TIME_ZONE_PREFIX = "GMT";
    private static final long serialVersionUID = 3227248503779092127L;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int INDENT_SIZE = 4;
    private static final int TIME_ZONE_LENGTH = 5;
    private static final char PAD_CHAR = '0';

    public PropertyListConfiguration() {
    }

    public PropertyListConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        super(hierarchicalConfiguration);
    }

    public PropertyListConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public PropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public PropertyListConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, Object object) {
        if (object instanceof byte[]) {
            this.fireEvent(3, string, object, true);
            this.setDetailEvents(false);
            try {
                this.clearProperty(string);
                this.addPropertyDirect(string, object);
            }
            finally {
                this.setDetailEvents(true);
            }
            this.fireEvent(3, string, object, false);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public void addProperty(String string, Object object) {
        if (object instanceof byte[]) {
            this.fireEvent(1, string, object, true);
            this.addPropertyDirect(string, object);
            this.fireEvent(1, string, object, false);
        } else {
            super.addProperty(string, object);
        }
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        PropertyListParser propertyListParser = new PropertyListParser(reader);
        try {
            PropertyListConfiguration propertyListConfiguration = propertyListParser.parse();
            this.setRoot(propertyListConfiguration.getRoot());
        }
        catch (ParseException parseException) {
            throw new ConfigurationException(parseException);
        }
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(writer);
        this.printNode(printWriter, 0, this.getRoot());
        printWriter.flush();
    }

    private void printNode(PrintWriter printWriter, int n, ConfigurationNode configurationNode) {
        ArrayList<ConfigurationNode> arrayList;
        String string = StringUtils.repeat(" ", n * 4);
        if (configurationNode.getName() != null) {
            printWriter.print(string + this.quoteString(configurationNode.getName()) + " = ");
        }
        if (!(arrayList = new ArrayList<ConfigurationNode>(configurationNode.getChildren())).isEmpty()) {
            if (n > 0) {
                printWriter.println();
            }
            printWriter.println(string + "{");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ConfigurationNode configurationNode2 = (ConfigurationNode)iterator.next();
                this.printNode(printWriter, n + 1, configurationNode2);
                Object object = configurationNode2.getValue();
                if (object != null && !(object instanceof Map) && !(object instanceof Configuration)) {
                    printWriter.println(";");
                }
                if (!iterator.hasNext() || object != null && !(object instanceof List)) continue;
                printWriter.println();
            }
            printWriter.print(string + "}");
            if (configurationNode.getParentNode() != null) {
                printWriter.println();
            }
        } else if (configurationNode.getValue() == null) {
            printWriter.println();
            printWriter.print(string + "{ };");
            if (configurationNode.getParentNode() != null) {
                printWriter.println();
            }
        } else {
            Object object = configurationNode.getValue();
            this.printValue(printWriter, n, object);
        }
    }

    private void printValue(PrintWriter printWriter, int n, Object object) {
        String string = StringUtils.repeat(" ", n * 4);
        if (object instanceof List) {
            printWriter.print("( ");
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.printValue(printWriter, n + 1, iterator.next());
                if (!iterator.hasNext()) continue;
                printWriter.print(", ");
            }
            printWriter.print(" )");
        } else if (object instanceof HierarchicalConfiguration) {
            this.printNode(printWriter, n, ((HierarchicalConfiguration)object).getRoot());
        } else if (object instanceof Configuration) {
            printWriter.println();
            printWriter.println(string + "{");
            Configuration configuration = (Configuration)object;
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(string2);
                node.setValue(configuration.getProperty(string2));
                this.printNode(printWriter, n + 1, node);
                printWriter.println(";");
            }
            printWriter.println(string + "}");
        } else if (object instanceof Map) {
            Map<String, Object> map = PropertyListConfiguration.transformMap((Map)object);
            this.printValue(printWriter, n, new MapConfiguration(map));
        } else if (object instanceof byte[]) {
            printWriter.print("<" + new String(Hex.encodeHex((byte[])((byte[])object))) + ">");
        } else if (object instanceof Date) {
            printWriter.print(PropertyListConfiguration.formatDate((Date)object));
        } else if (object != null) {
            printWriter.print(this.quoteString(String.valueOf(object)));
        }
    }

    String quoteString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(32) != -1 || string.indexOf(9) != -1 || string.indexOf(13) != -1 || string.indexOf(10) != -1 || string.indexOf(34) != -1 || string.indexOf(40) != -1 || string.indexOf(41) != -1 || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(61) != -1 || string.indexOf(44) != -1 || string.indexOf(59) != -1) {
            string = string.replaceAll("\"", "\\\\\\\"");
            string = "\"" + string + "\"";
        }
        return string;
    }

    static Date parseDate(String string) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int n = 0;
        for (DateComponentParser dateComponentParser : DATE_PARSERS) {
            n += dateComponentParser.parseComponent(string, n, calendar);
        }
        return calendar.getTime();
    }

    static String formatDate(Calendar calendar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < DATE_PARSERS.length; ++i) {
            DATE_PARSERS[i].formatComponent(stringBuilder, calendar);
        }
        return stringBuilder.toString();
    }

    static String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return PropertyListConfiguration.formatDate(calendar);
    }

    private static Map<String, Object> transformMap(Map<?, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            hashMap.put((String)entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private static class DateTimeZoneParser
    extends DateComponentParser {
        private DateTimeZoneParser() {
        }

        public void formatComponent(StringBuilder stringBuilder, Calendar calendar) {
            TimeZone timeZone = calendar.getTimeZone();
            int n = timeZone.getRawOffset() / 60000;
            if (n < 0) {
                stringBuilder.append('-');
                n = -n;
            } else {
                stringBuilder.append('+');
            }
            int n2 = n / 60;
            int n3 = n % 60;
            this.padNum(stringBuilder, n2, 2);
            this.padNum(stringBuilder, n3, 2);
        }

        public int parseComponent(String string, int n, Calendar calendar) throws ParseException {
            this.checkLength(string, n, 5);
            TimeZone timeZone = TimeZone.getTimeZone(PropertyListConfiguration.TIME_ZONE_PREFIX + string.substring(n, n + 5));
            calendar.setTimeZone(timeZone);
            return 5;
        }
    }

    private static class DateSeparatorParser
    extends DateComponentParser {
        private String separator;

        public DateSeparatorParser(String string) {
            this.separator = string;
        }

        public void formatComponent(StringBuilder stringBuilder, Calendar calendar) {
            stringBuilder.append(this.separator);
        }

        public int parseComponent(String string, int n, Calendar calendar) throws ParseException {
            this.checkLength(string, n, this.separator.length());
            if (!string.startsWith(this.separator, n)) {
                throw new ParseException("Invalid input: " + string + ", index " + n + ", expected " + this.separator);
            }
            return this.separator.length();
        }
    }

    private static class DateFieldParser
    extends DateComponentParser {
        private int calendarField;
        private int length;
        private int offset;

        public DateFieldParser(int n, int n2) {
            this(n, n2, 0);
        }

        public DateFieldParser(int n, int n2, int n3) {
            this.calendarField = n;
            this.length = n2;
            this.offset = n3;
        }

        public void formatComponent(StringBuilder stringBuilder, Calendar calendar) {
            this.padNum(stringBuilder, calendar.get(this.calendarField) + this.offset, this.length);
        }

        public int parseComponent(String string, int n, Calendar calendar) throws ParseException {
            this.checkLength(string, n, this.length);
            try {
                calendar.set(this.calendarField, Integer.parseInt(string.substring(n, n + this.length)) - this.offset);
                return this.length;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid number: " + string + ", index " + n);
            }
        }
    }

    private static abstract class DateComponentParser {
        private DateComponentParser() {
        }

        public abstract int parseComponent(String var1, int var2, Calendar var3) throws ParseException;

        public abstract void formatComponent(StringBuilder var1, Calendar var2);

        protected void checkLength(String string, int n, int n2) throws ParseException {
            int n3;
            int n4 = n3 = string == null ? 0 : string.length();
            if (n + n2 > n3) {
                throw new ParseException("Input string too short: " + string + ", index: " + n);
            }
        }

        protected void padNum(StringBuilder stringBuilder, int n, int n2) {
            stringBuilder.append(StringUtils.leftPad(String.valueOf(n), n2, '0'));
        }
    }
}

