/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.provider.AbstractClientFactoryProvider;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.client.ConnectionFactoryProvider;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.packet.HandshakePropertyType;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import java.util.HashMap;
import java.util.Map;

public class PinpointClientFactoryProvider
extends AbstractClientFactoryProvider
implements Provider<PinpointClientFactory> {
    private final ProfilerConfig profilerConfig;
    private final Provider<AgentInformation> agentInformation;
    private final Provider<ConnectionFactoryProvider> connectionFactoryProvider;
    private final CommandDispatcher commandDispatcher;

    @Inject
    public PinpointClientFactoryProvider(ProfilerConfig profilerConfig, Provider<AgentInformation> agentInformation, CommandDispatcher commandDispatcher, Provider<ConnectionFactoryProvider> connectionFactoryProvider) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (agentInformation == null) {
            throw new NullPointerException("agentInformation must not be null");
        }
        if (commandDispatcher == null) {
            throw new NullPointerException("commandDispatcher must not be null");
        }
        if (connectionFactoryProvider == null) {
            throw new NullPointerException("connectionFactoryProvider must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.agentInformation = agentInformation;
        this.commandDispatcher = commandDispatcher;
        this.connectionFactoryProvider = connectionFactoryProvider;
    }

    public PinpointClientFactory get() {
        DefaultPinpointClientFactory pinpointClientFactory = new DefaultPinpointClientFactory((ConnectionFactoryProvider)this.connectionFactoryProvider.get());
        pinpointClientFactory.setWriteTimeoutMillis(this.profilerConfig.getTcpDataSenderPinpointClientWriteTimeout());
        pinpointClientFactory.setRequestTimeoutMillis(this.profilerConfig.getTcpDataSenderPinpointClientRequestTimeout());
        pinpointClientFactory.setReconnectDelay(this.profilerConfig.getTcpDataSenderPinpointClientReconnectInterval());
        pinpointClientFactory.setPingDelay(this.profilerConfig.getTcpDataSenderPinpointClientPingInterval());
        pinpointClientFactory.setEnableWorkerPacketDelay(this.profilerConfig.getTcpDataSenderPinpointClientHandshakeInterval());
        int writeBufferHighWaterMark = this.getByteSize(this.profilerConfig.getSpanDataSenderWriteBufferHighWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(16L));
        int writeBufferLowWaterMark = this.getByteSize(this.profilerConfig.getSpanDataSenderWriteBufferLowWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(8L));
        if (writeBufferLowWaterMark > writeBufferHighWaterMark) {
            this.logger.warn("must be writeBufferHighWaterMark({}) >= writeBufferLowWaterMark({})", (Object)writeBufferHighWaterMark, (Object)writeBufferLowWaterMark);
            writeBufferLowWaterMark = writeBufferHighWaterMark;
        }
        pinpointClientFactory.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        pinpointClientFactory.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        AgentInformation agentInformation = (AgentInformation)this.agentInformation.get();
        Map<String, Object> properties = this.toMap(agentInformation);
        boolean isSupportServerMode = this.profilerConfig.isTcpDataSenderCommandAcceptEnable();
        if (isSupportServerMode) {
            pinpointClientFactory.setMessageListener((MessageListener)this.commandDispatcher);
            pinpointClientFactory.setServerStreamChannelMessageListener((ServerStreamChannelMessageListener)this.commandDispatcher);
            properties.put(HandshakePropertyType.SUPPORT_SERVER.getName(), true);
            properties.put(HandshakePropertyType.SUPPORT_COMMAND_LIST.getName(), this.commandDispatcher.getRegisteredCommandServiceCodes());
        } else {
            properties.put(HandshakePropertyType.SUPPORT_SERVER.getName(), false);
        }
        pinpointClientFactory.setProperties(properties);
        return pinpointClientFactory;
    }

    private Map<String, Object> toMap(AgentInformation agentInformation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HandshakePropertyType.AGENT_ID.getName(), agentInformation.getAgentId());
        map.put(HandshakePropertyType.APPLICATION_NAME.getName(), agentInformation.getApplicationName());
        map.put(HandshakePropertyType.HOSTNAME.getName(), agentInformation.getMachineName());
        map.put(HandshakePropertyType.IP.getName(), agentInformation.getHostIp());
        map.put(HandshakePropertyType.PID.getName(), agentInformation.getPid());
        map.put(HandshakePropertyType.SERVICE_TYPE.getName(), agentInformation.getServerType().getCode());
        map.put(HandshakePropertyType.START_TIMESTAMP.getName(), agentInformation.getStartTime());
        map.put(HandshakePropertyType.VERSION.getName(), agentInformation.getAgentVersion());
        return map;
    }
}

