/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rxjava;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilters;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.rxjava.transformer.SchedulerWorkerTransformCallback;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.rxjava.RxJavaPluginConfig;
import com.navercorp.pinpoint.plugin.rxjava.RxJavaPluginConstants;
import java.security.ProtectionDomain;

public class RxJavaPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;
    private final TransformCallback scheduledActionTransformCallback = new TransformCallback(){

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod call = target.getDeclaredMethod("call", new String[0]);
            if (call == null) {
                return null;
            }
            target.addField(AsyncContextAccessor.class.getName());
            call.addInterceptor("com.navercorp.pinpoint.plugin.rxjava.interceptor.SubscriptionTraceEnabledMethodInterceptor");
            return target.toBytecode();
        }
    };

    public void setup(ProfilerPluginSetupContext context) {
        RxJavaPluginConfig config = new RxJavaPluginConfig(context.getConfig());
        if (config.isTraceRxJava()) {
            this.addObservableTransformers();
            this.addScheduledActionTransformers();
            this.addSchedulerWorkerTransformers();
        }
    }

    private void addObservableTransformers() {
        this.transformTemplate.transform("rx.Observable", (TransformCallback)new ObservableTransformCallback(new String[]{"toBlocking", "publish", "groupBy"}));
        this.transformTemplate.transform("rx.observables.BlockingObservable", (TransformCallback)new ObservableTransformCallback(new String[]{"first", "firstOrDefault", "mostRecent", "last", "lastOrDefault", "latest", "single", "singleOrDefault", "next", "forEach", "getIterator", "toFuture", "toIterable", "blockForSingle"}));
        this.transformTemplate.transform("rx.observables.ConnectableObservable", (TransformCallback)new ObservableTransformCallback(new String[]{"connect", "autoConnect", "refCount"}));
        ObservableTransformCallback.NestedScheduledActionTransformer rxSingleNestedScheduledActionTransformer = new ObservableTransformCallback.NestedScheduledActionTransformer(){

            @Override
            public void transformNestedScheduledActions(InstrumentClass target, Instrumentor instrumentor, ClassLoader classLoader) {
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"subscribeOn", (String[])new String[]{"rx.Scheduler"}), ClassFilters.interfaze((String[])new String[]{"rx.Single$OnSubscribe"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.SingleSubscriber"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
            }
        };
        this.transformTemplate.transform("rx.Single", (TransformCallback)new ObservableTransformCallback(rxSingleNestedScheduledActionTransformer, new String[]{"toBlocking"}));
        this.transformTemplate.transform("rx.singles.BlockingSingle", (TransformCallback)new ObservableTransformCallback(new String[]{"value", "toFuture"}));
        ObservableTransformCallback.NestedScheduledActionTransformer rxCompletableNestedScheduledActionTransformer = new ObservableTransformCallback.NestedScheduledActionTransformer(){

            @Override
            public void transformNestedScheduledActions(InstrumentClass target, Instrumentor instrumentor, ClassLoader classLoader) {
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"subscribeOn", (String[])new String[]{"rx.Scheduler"}), ClassFilters.interfaze((String[])new String[]{"rx.Completable$CompletableOnSubscribe"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.Completable$CompletableSubscriber"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"subscribeOn", (String[])new String[]{"rx.Scheduler"}), ClassFilters.interfaze((String[])new String[]{"rx.Completable$CompletableOnSubscribe"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.CompletableSubscriber"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"subscribeOn", (String[])new String[]{"rx.Scheduler"}), ClassFilters.interfaze((String[])new String[]{"rx.Completable$OnSubscribe"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.CompletableSubscriber"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
            }
        };
        this.transformTemplate.transform("rx.Completable", (TransformCallback)new ObservableTransformCallback(rxCompletableNestedScheduledActionTransformer, new String[]{"await", "get"}));
    }

    private void addScheduledActionTransformers() {
        this.transformTemplate.transform("rx.internal.operators.OperatorSubscribeOn", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.Subscriber"}), ClassFilters.name((String[])new String[]{"rx.internal.operators.OperatorSubscribeOn$1"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"onNext", (String[])new String[]{"rx.Observable"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
                for (InstrumentClass nestedClass : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.Subscriber"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                    instrumentor.transform(classLoader, nestedClass.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                }
                for (InstrumentClass nestedClass : target.getNestedClasses(ClassFilters.name((String[])new String[]{"rx.internal.operators.OperatorSubscribeOn$SubscribeOnSubscriber"}))) {
                    instrumentor.transform(classLoader, nestedClass.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("rx.internal.util.ScalarSynchronousObservable", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentClass nestedClass1 : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"scalarScheduleOn", (String[])new String[]{"rx.Scheduler"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Func1"})}))) {
                    for (InstrumentClass nestedClass2 : nestedClass1.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.functions.Action0"}), ClassFilters.interfaze((String[])new String[]{"rx.functions.Action0"})}))) {
                        instrumentor.transform(classLoader, nestedClass2.getName(), RxJavaPlugin.this.scheduledActionTransformCallback);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("rx.internal.util.ScalarSynchronousObservable$ScalarSynchronousAction", this.scheduledActionTransformCallback);
        this.transformTemplate.transform("rx.internal.util.ScalarSynchronousSingleAction", this.scheduledActionTransformCallback);
    }

    private void addSchedulerWorkerTransformers() {
        SchedulerWorkerTransformCallback callback = SchedulerWorkerTransformCallback.createFor((ServiceType)RxJavaPluginConstants.RX_JAVA_INTERNAL);
        this.transformTemplate.transform("rx.internal.schedulers.EventLoopsScheduler$EventLoopWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.internal.schedulers.CachedThreadScheduler$EventLoopWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.internal.schedulers.ExecutorScheduler$ExecutorSchedulerWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.internal.schedulers.NewThreadWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.schedulers.EventLoopsScheduler$EventLoopWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.schedulers.CachedThreadScheduler$EventLoopWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.schedulers.ExecutorScheduler$ExecutorSchedulerWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.schedulers.NewThreadWorker", (TransformCallback)callback);
        this.transformTemplate.transform("rx.internal.schedulers.EventLoopsScheduler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod scheduleDirect = target.getDeclaredMethod("scheduleDirect", new String[]{"rx.functions.Action0"});
                if (scheduleDirect != null) {
                    scheduleDirect.addInterceptor("com.navercorp.pinpoint.plugin.rxjava.interceptor.EventLoopsSchedulerScheduleDirectInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static class ObservableTransformCallback
    implements TransformCallback {
        private static final NestedScheduledActionTransformer NONE = null;
        private final NestedScheduledActionTransformer nestedScheduledActionTransformer;
        private final String[] traceMethods;

        private ObservableTransformCallback(String ... traceMethods) {
            this(NONE, traceMethods);
        }

        private ObservableTransformCallback(NestedScheduledActionTransformer nestedScheduledActionTransformer, String ... traceMethods) {
            this.nestedScheduledActionTransformer = nestedScheduledActionTransformer;
            this.traceMethods = traceMethods;
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            if (this.nestedScheduledActionTransformer != NONE) {
                this.nestedScheduledActionTransformer.transformNestedScheduledActions(target, instrumentor, classLoader);
            }
            for (InstrumentMethod subscribe : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"subscribe"}))) {
                subscribe.addScopedInterceptor("com.navercorp.pinpoint.plugin.rxjava.interceptor.ObservableSubscribeInterceptor", "RxJavaObservableSubscribeScope", ExecutionPolicy.BOUNDARY);
            }
            for (InstrumentMethod traceMethod : target.getDeclaredMethods(MethodFilters.name((String[])this.traceMethods))) {
                traceMethod.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{RxJavaPluginConstants.RX_JAVA}), "RxJavaObservableScope", ExecutionPolicy.BOUNDARY);
            }
            return target.toBytecode();
        }

        static interface NestedScheduledActionTransformer {
            public void transformNestedScheduledActions(InstrumentClass var1, Instrumentor var2, ClassLoader var3);
        }
    }
}

