/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.datasource;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetric;
import com.navercorp.pinpoint.thrift.dto.TDataSource;
import com.navercorp.pinpoint.thrift.dto.TDataSourceList;
import java.util.List;

public class DefaultDataSourceMetricCollector
implements AgentStatMetricCollector<TDataSourceList> {
    private final DataSourceMetric dataSourceMetric;

    public DefaultDataSourceMetricCollector(DataSourceMetric dataSourceMetric) {
        if (dataSourceMetric == null) {
            throw new NullPointerException("dataSourceMetric must not be null");
        }
        this.dataSourceMetric = dataSourceMetric;
    }

    @Override
    public TDataSourceList collect() {
        List<DataSource> dataSources = this.dataSourceMetric.dataSourceList();
        if (CollectionUtils.isEmpty(dataSources)) {
            return new TDataSourceList();
        }
        TDataSourceList tDataSourceList = new TDataSourceList();
        for (DataSource dataSource : dataSources) {
            TDataSource tDataSource = this.toTDataSource(dataSource);
            tDataSourceList.addToDataSourceList(tDataSource);
        }
        return tDataSourceList;
    }

    private TDataSource toTDataSource(DataSource dataSource) {
        TDataSource tDataSource = new TDataSource(dataSource.getId());
        tDataSource.setServiceTypeCode(dataSource.getServiceTypeCode());
        if (dataSource.getDatabaseName() != null) {
            tDataSource.setDatabaseName(dataSource.getDatabaseName());
        }
        if (dataSource.getActiveConnectionSize() != 0) {
            tDataSource.setActiveConnectionSize(dataSource.getActiveConnectionSize());
        }
        if (dataSource.getUrl() != null) {
            tDataSource.setUrl(dataSource.getUrl());
        }
        tDataSource.setMaxConnectionSize(dataSource.getMaxConnectionSize());
        return tDataSource;
    }
}

