/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.cpu;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.TCpuLoad;

public class DefaultCpuLoadMetricCollector
implements AgentStatMetricCollector<TCpuLoad> {
    private final CpuLoadMetric cpuLoadMetric;

    public DefaultCpuLoadMetricCollector(CpuLoadMetric cpuLoadMetric) {
        if (cpuLoadMetric == null) {
            throw new NullPointerException("cpuLoadMetric must not be null");
        }
        this.cpuLoadMetric = cpuLoadMetric;
    }

    @Override
    public TCpuLoad collect() {
        CpuLoadMetricSnapshot snapshot = this.cpuLoadMetric.getSnapshot();
        TCpuLoad cpuLoad = new TCpuLoad();
        cpuLoad.setJvmCpuLoad(snapshot.getJvmCpuUsage());
        cpuLoad.setSystemCpuLoad(snapshot.getSystemCpuUsage());
        return cpuLoad;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultCpuLoadMetricCollector{");
        sb.append("cpuLoadMetric=").append(this.cpuLoadMetric);
        sb.append('}');
        return sb.toString();
    }
}

