/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.logging;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerBinder;
import com.navercorp.pinpoint.profiler.logging.Slf4jPLoggerAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerBinder
implements PLoggerBinder {
    private ConcurrentMap<String, PLogger> loggerCache = new ConcurrentHashMap<String, PLogger>(256, 0.75f, 128);

    public PLogger getLogger(String name) {
        PLogger hitPLogger = (PLogger)this.loggerCache.get(name);
        if (hitPLogger != null) {
            return hitPLogger;
        }
        Logger slf4jLogger = LoggerFactory.getLogger((String)name);
        Slf4jPLoggerAdapter slf4jLoggerAdapter = new Slf4jPLoggerAdapter(slf4jLogger);
        PLogger before = this.loggerCache.putIfAbsent(name, slf4jLoggerAdapter);
        if (before != null) {
            return before;
        }
        return slf4jLoggerAdapter;
    }

    public void shutdown() {
        this.loggerCache = null;
    }
}

