/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DirectoryScanner
implements Scanner {
    private final String directory;

    public DirectoryScanner(String directory) {
        this.directory = (String)Assert.requireNonNull((Object)directory, (String)"directory must not be null");
    }

    @Override
    public boolean exist(String fileName) {
        Assert.requireNonNull((Object)fileName, (String)"fileName must not be null");
        String fullPath = this.getFullPath(fileName);
        File file = new File(fullPath);
        return file.isFile();
    }

    private String getFullPath(String fileName) {
        return this.directory + fileName;
    }

    @Override
    public InputStream openStream(String fileName) {
        Assert.requireNonNull((Object)fileName, (String)"fileName must not be null");
        String fullPath = this.getFullPath(fileName);
        try {
            return new FileInputStream(fullPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "DirectoryScanner{directory='" + this.directory + '\'' + '}';
    }
}

