/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.interceptor;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.profiler.instrument.interceptor.CodeBuilder;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InvokeCodeGenerator;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import java.lang.reflect.Method;

public class InvokeBeforeCodeGenerator
extends InvokeCodeGenerator {
    private final int interceptorId;
    private final InstrumentClass targetClass;

    public InvokeBeforeCodeGenerator(int interceptorId, InterceptorDefinition interceptorDefinition, InstrumentClass targetClass, InstrumentMethod targetMethod, ApiMetaDataService apiMetaDataService) {
        super(interceptorId, interceptorDefinition, targetMethod, apiMetaDataService);
        this.interceptorId = interceptorId;
        this.targetClass = targetClass;
    }

    public String generate() {
        CodeBuilder builder = new CodeBuilder();
        builder.begin();
        builder.format("%1$s = %2$s.getInterceptor(%3$d); ", this.getInterceptorVar(), this.getInterceptorRegistryClassName(), this.interceptorId);
        Method beforeMethod = this.interceptorDefinition.getBeforeMethod();
        if (beforeMethod != null) {
            builder.format("((%1$s)%2$s).before(", this.getInterceptorType(), this.getInterceptorVar());
            this.appendArguments(builder);
            builder.format(");", new Object[0]);
        }
        builder.end();
        return builder.toString();
    }

    private void appendArguments(CodeBuilder builder) {
        InterceptorType type = this.interceptorDefinition.getInterceptorType();
        switch (type) {
            case ARRAY_ARGS: {
                this.appendSimpleBeforeArguments(builder);
                break;
            }
            case STATIC: {
                this.appendStaticBeforeArguments(builder);
                break;
            }
            case API_ID_AWARE: {
                this.appendApiIdAwareBeforeArguments(builder);
                break;
            }
            case BASIC: {
                this.appendCustomBeforeArguments(builder);
            }
        }
    }

    private void appendSimpleBeforeArguments(CodeBuilder builder) {
        builder.format("%1$s, %2$s", this.getTarget(), this.getArguments());
    }

    private void appendStaticBeforeArguments(CodeBuilder builder) {
        builder.format("%1$s, \"%2$s\", \"%3$s\", \"%4$s\", %5$s", this.getTarget(), this.targetClass.getName(), this.targetMethod.getName(), this.getParameterTypes(), this.getArguments());
    }

    private void appendApiIdAwareBeforeArguments(CodeBuilder builder) {
        builder.format("%1$s, %2$d, %3$s", this.getTarget(), this.getApiId(), this.getArguments());
    }

    private void appendCustomBeforeArguments(CodeBuilder builder) {
        int i;
        Method interceptorMethod = this.interceptorDefinition.getBeforeMethod();
        Class<?>[] paramTypes = interceptorMethod.getParameterTypes();
        if (paramTypes.length == 0) {
            return;
        }
        builder.append(this.getTarget());
        int argNum = this.targetMethod.getParameterTypes().length;
        int interceptorArgNum = paramTypes.length - 1;
        int matchNum = Math.min(argNum, interceptorArgNum);
        for (i = 0; i < matchNum; ++i) {
            builder.append(", ($w)$" + (i + 1));
        }
        while (i < interceptorArgNum) {
            builder.append(", null");
            ++i;
        }
    }
}

