/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;

public class DisableTrace
implements Trace {
    public static final String UNSUPPORTED_OPERATION = "disable trace";
    public static final long DISABLE_TRACE_OBJECT_ID = -1L;
    private final long id;
    private final long startTime;
    private final long threadId;
    private final DefaultTraceScopePool scopePool = new DefaultTraceScopePool();
    private final ActiveTraceHandle handle;
    private boolean closed = false;

    public DisableTrace(long id, long startTime, long threadId, ActiveTraceHandle handle) {
        this.id = id;
        this.startTime = startTime;
        this.threadId = threadId;
        this.handle = (ActiveTraceHandle)Assert.requireNonNull((Object)handle, (String)"handle must not be null");
    }

    public long getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Thread getBindThread() {
        return null;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public SpanEventRecorder traceBlockBegin() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public TraceId getTraceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public AsyncTraceId getAsyncTraceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        long purgeTime = System.currentTimeMillis();
        this.handle.purge(purgeTime);
    }

    public int getCallStackFrameId() {
        return 0;
    }

    public SpanRecorder getSpanRecorder() {
        return null;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return null;
    }

    public TraceScope getScope(String name) {
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        return this.scopePool.add(name);
    }
}

