/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.navercorp.pinpoint.rpc.util.ClassUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum HandshakePropertyType {
    SUPPORT_SERVER("supportServer", Boolean.class, false),
    SUPPORT_COMMAND_LIST("supportCommandList", List.class, false),
    HOSTNAME("hostName", String.class),
    IP("ip", String.class),
    AGENT_ID("agentId", String.class),
    APPLICATION_NAME("applicationName", String.class),
    SERVICE_TYPE("serviceType", Integer.class),
    PID("pid", Integer.class),
    VERSION("version", String.class),
    START_TIMESTAMP("startTimestamp", Long.class);

    private final String name;
    private final Class clazzType;
    private final boolean isRequired;
    private static final Set<HandshakePropertyType> HANDSHAKE_PROPERTY_TYPE;

    private HandshakePropertyType(String name, Class clazzType) {
        this(name, clazzType, true);
    }

    private HandshakePropertyType(String name, Class clazzType, boolean isRequired) {
        this.name = name;
        this.clazzType = clazzType;
        this.isRequired = isRequired;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazzType() {
        return this.clazzType;
    }

    public static boolean hasRequiredKeys(Map properties) {
        for (HandshakePropertyType type : HANDSHAKE_PROPERTY_TYPE) {
            if (!type.isRequired) continue;
            Object value = properties.get(type.getName());
            if (value == null) {
                return false;
            }
            if (ClassUtils.isAssignable(value.getClass(), type.getClazzType())) continue;
            return false;
        }
        return true;
    }

    static {
        HANDSHAKE_PROPERTY_TYPE = EnumSet.allOf(HandshakePropertyType.class);
    }
}

