/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.activemq.client;

import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.common.util.StringUtils;

public class ActiveMQClientPluginConfig {
    public static final String DEFAULT_DESTINATION_PATH_SEPARATOR = ".";
    private final boolean traceActiveMQClient;
    private final boolean traceActiveMQClientProducer;
    private final boolean traceActiveMQClientConsumer;
    private final boolean traceActiveMQTextMessage;
    private final Filter<String> excludeDestinationFilter;

    public ActiveMQClientPluginConfig(ProfilerConfig config) {
        String excludeDestinations;
        this.traceActiveMQClient = config.readBoolean("profiler.activemq.client.enable", true);
        this.traceActiveMQClientProducer = config.readBoolean("profiler.activemq.client.producer.enable", true);
        this.traceActiveMQClientConsumer = config.readBoolean("profiler.activemq.client.consumer.enable", true);
        this.traceActiveMQTextMessage = config.readBoolean("profiler.activemq.client.trace.message", false);
        String excludeDestinationPathSeparator = config.readString("profiler.activemq.client.destination.separator", DEFAULT_DESTINATION_PATH_SEPARATOR);
        if (StringUtils.isEmpty((String)excludeDestinationPathSeparator)) {
            excludeDestinationPathSeparator = DEFAULT_DESTINATION_PATH_SEPARATOR;
        }
        this.excludeDestinationFilter = !(excludeDestinations = config.readString("profiler.activemq.client.destination.exclude", "")).isEmpty() ? new ExcludePathFilter(excludeDestinations, excludeDestinationPathSeparator) : new SkipFilter();
    }

    public boolean isTraceActiveMQClient() {
        return this.traceActiveMQClient;
    }

    public boolean isTraceActiveMQClientProducer() {
        return this.traceActiveMQClientProducer;
    }

    public boolean isTraceActiveMQClientConsumer() {
        return this.traceActiveMQClientConsumer;
    }

    public boolean isTraceActiveMQTextMessage() {
        return this.traceActiveMQTextMessage;
    }

    public Filter<String> getExcludeDestinationFilter() {
        return this.excludeDestinationFilter;
    }
}

