/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.plist;

import com.secnium.iast.thirdparty.org.apache.commons.codec.binary.Base64;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.MapConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringEscapeUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final long serialVersionUID = -3162063751042475985L;
    private static final int INDENT_SIZE = 4;

    public XMLPropertyListConfiguration() {
        this.initRoot();
    }

    public XMLPropertyListConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        super(hierarchicalConfiguration);
    }

    public XMLPropertyListConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public XMLPropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public XMLPropertyListConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, Object object) {
        if (object instanceof byte[]) {
            this.fireEvent(3, string, object, true);
            this.setDetailEvents(false);
            try {
                this.clearProperty(string);
                this.addPropertyDirect(string, object);
            }
            finally {
                this.setDetailEvents(true);
            }
            this.fireEvent(3, string, object, false);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public void addProperty(String string, Object object) {
        if (object instanceof byte[]) {
            this.fireEvent(1, string, object, true);
            this.addPropertyDirect(string, object);
            this.fireEvent(1, string, object, false);
        } else {
            super.addProperty(string, object);
        }
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        if (!(this.getRootNode() instanceof PListNode)) {
            this.initRoot();
        }
        EntityResolver entityResolver = new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("PropertyList-1.0.dtd"));
            }
        };
        XMLPropertyListHandler xMLPropertyListHandler = new XMLPropertyListHandler(this.getRoot());
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.getXMLReader().setEntityResolver(entityResolver);
            sAXParser.getXMLReader().setContentHandler(xMLPropertyListHandler);
            sAXParser.getXMLReader().parse(new InputSource(reader));
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to parse the configuration file", exception);
        }
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.getEncoding() != null) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        } else {
            printWriter.println("<?xml version=\"1.0\"?>");
        }
        printWriter.println("<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">");
        printWriter.println("<plist version=\"1.0\">");
        this.printNode(printWriter, 1, this.getRoot());
        printWriter.println("</plist>");
        printWriter.flush();
    }

    private void printNode(PrintWriter printWriter, int n, ConfigurationNode configurationNode) {
        List<ConfigurationNode> list;
        String string = StringUtils.repeat(" ", n * 4);
        if (configurationNode.getName() != null) {
            printWriter.println(string + "<key>" + StringEscapeUtils.escapeXml(configurationNode.getName()) + "</key>");
        }
        if (!(list = configurationNode.getChildren()).isEmpty()) {
            printWriter.println(string + "<dict>");
            Iterator<ConfigurationNode> iterator = list.iterator();
            while (iterator.hasNext()) {
                ConfigurationNode configurationNode2 = iterator.next();
                this.printNode(printWriter, n + 1, configurationNode2);
                if (!iterator.hasNext()) continue;
                printWriter.println();
            }
            printWriter.println(string + "</dict>");
        } else if (configurationNode.getValue() == null) {
            printWriter.println(string + "<dict/>");
        } else {
            Object object = configurationNode.getValue();
            this.printValue(printWriter, n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printValue(PrintWriter printWriter, int n, Object object) {
        String string = StringUtils.repeat(" ", n * 4);
        if (object instanceof Date) {
            DateFormat dateFormat = PListNode.FORMAT;
            synchronized (dateFormat) {
                printWriter.println(string + "<date>" + PListNode.FORMAT.format((Date)object) + "</date>");
            }
        } else if (object instanceof Calendar) {
            this.printValue(printWriter, n, ((Calendar)object).getTime());
        } else if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float || object instanceof BigDecimal) {
                printWriter.println(string + "<real>" + object.toString() + "</real>");
            } else {
                printWriter.println(string + "<integer>" + object.toString() + "</integer>");
            }
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                printWriter.println(string + "<true/>");
            } else {
                printWriter.println(string + "<false/>");
            }
        } else if (object instanceof List) {
            printWriter.println(string + "<array>");
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.printValue(printWriter, n + 1, iterator.next());
            }
            printWriter.println(string + "</array>");
        } else if (object instanceof HierarchicalConfiguration) {
            this.printNode(printWriter, n, ((HierarchicalConfiguration)object).getRoot());
        } else if (object instanceof Configuration) {
            printWriter.println(string + "<dict>");
            Configuration configuration = (Configuration)object;
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(string2);
                node.setValue(configuration.getProperty(string2));
                this.printNode(printWriter, n + 1, node);
                if (!iterator.hasNext()) continue;
                printWriter.println();
            }
            printWriter.println(string + "</dict>");
        } else if (object instanceof Map) {
            Map<String, Object> map = XMLPropertyListConfiguration.transformMap((Map)object);
            this.printValue(printWriter, n, new MapConfiguration(map));
        } else if (object instanceof byte[]) {
            String string3 = new String(Base64.encodeBase64((byte[])((byte[])object)));
            printWriter.println(string + "<data>" + StringEscapeUtils.escapeXml(string3) + "</data>");
        } else if (object != null) {
            printWriter.println(string + "<string>" + StringEscapeUtils.escapeXml(String.valueOf(object)) + "</string>");
        } else {
            printWriter.println(string + "<string/>");
        }
    }

    private void initRoot() {
        this.setRootNode(new PListNode());
    }

    private static Map<String, Object> transformMap(Map<?, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            hashMap.put((String)entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static class ArrayNode
    extends PListNode {
        private static final long serialVersionUID = 5586544306664205835L;
        private List<Object> list = new ArrayList<Object>();

        public void addValue(Object object) {
            this.list.add(object);
        }

        public Object getValue() {
            return this.list;
        }
    }

    public static class PListNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -7614060264754798317L;
        private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        private static final DateFormat GNUSTEP_FORMAT;

        public void addValue(Object object) {
            if (this.getValue() == null) {
                this.setValue(object);
            } else if (this.getValue() instanceof Collection) {
                Collection collection = (Collection)this.getValue();
                collection.add(object);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.getValue());
                arrayList.add(object);
                this.setValue(arrayList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDateValue(String string) {
            block9: {
                try {
                    if (string.indexOf(32) != -1) {
                        DateFormat dateFormat = GNUSTEP_FORMAT;
                        synchronized (dateFormat) {
                            this.addValue(GNUSTEP_FORMAT.parse(string));
                            break block9;
                        }
                    }
                    DateFormat dateFormat = FORMAT;
                    synchronized (dateFormat) {
                        this.addValue(FORMAT.parse(string));
                    }
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(String.format("'%s' cannot be parsed to a date!", string), parseException);
                }
            }
        }

        public void addDataValue(String string) {
            this.addValue(Base64.decodeBase64((byte[])string.getBytes()));
        }

        public void addIntegerValue(String string) {
            this.addValue(new BigInteger(string));
        }

        public void addRealValue(String string) {
            this.addValue(new BigDecimal(string));
        }

        public void addTrueValue() {
            this.addValue(Boolean.TRUE);
        }

        public void addFalseValue() {
            this.addValue(Boolean.FALSE);
        }

        public void addList(ArrayNode arrayNode) {
            this.addValue(arrayNode.getValue());
        }

        static {
            FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
            GNUSTEP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        }
    }

    private class XMLPropertyListHandler
    extends DefaultHandler {
        private StringBuilder buffer = new StringBuilder();
        private List<HierarchicalConfiguration.Node> stack = new ArrayList<HierarchicalConfiguration.Node>();

        public XMLPropertyListHandler(HierarchicalConfiguration.Node node) {
            this.push(node);
        }

        private HierarchicalConfiguration.Node peek() {
            if (!this.stack.isEmpty()) {
                return this.stack.get(this.stack.size() - 1);
            }
            return null;
        }

        private HierarchicalConfiguration.Node pop() {
            if (!this.stack.isEmpty()) {
                return this.stack.remove(this.stack.size() - 1);
            }
            return null;
        }

        private void push(HierarchicalConfiguration.Node node) {
            this.stack.add(node);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("array".equals(string3)) {
                this.push(new ArrayNode());
            } else if ("dict".equals(string3) && this.peek() instanceof ArrayNode) {
                XMLPropertyListConfiguration xMLPropertyListConfiguration = new XMLPropertyListConfiguration();
                ArrayNode arrayNode = (ArrayNode)this.peek();
                arrayNode.addValue(xMLPropertyListConfiguration);
                this.push(xMLPropertyListConfiguration.getRoot());
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("key".equals(string3)) {
                PListNode pListNode = new PListNode();
                pListNode.setName(this.buffer.toString());
                this.peek().addChild(pListNode);
                this.push(pListNode);
            } else if ("dict".equals(string3)) {
                this.pop();
            } else {
                if ("string".equals(string3)) {
                    ((PListNode)this.peek()).addValue(this.buffer.toString());
                } else if ("integer".equals(string3)) {
                    ((PListNode)this.peek()).addIntegerValue(this.buffer.toString());
                } else if ("real".equals(string3)) {
                    ((PListNode)this.peek()).addRealValue(this.buffer.toString());
                } else if ("true".equals(string3)) {
                    ((PListNode)this.peek()).addTrueValue();
                } else if ("false".equals(string3)) {
                    ((PListNode)this.peek()).addFalseValue();
                } else if ("data".equals(string3)) {
                    ((PListNode)this.peek()).addDataValue(this.buffer.toString());
                } else if ("date".equals(string3)) {
                    try {
                        ((PListNode)this.peek()).addDateValue(this.buffer.toString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        XMLPropertyListConfiguration.this.getLogger().warn("Ignoring invalid date property " + this.buffer);
                    }
                } else if ("array".equals(string3)) {
                    ArrayNode arrayNode = (ArrayNode)this.pop();
                    ((PListNode)this.peek()).addList(arrayNode);
                }
                if (!(this.peek() instanceof ArrayNode)) {
                    this.pop();
                }
            }
            this.buffer.setLength(0);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }
    }
}

