/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.tomcat.TomcatConstants;
import java.util.Arrays;
import java.util.List;

public class TomcatDetector
implements ApplicationTypeDetector {
    private static final String DEFAULT_BOOTSTRAP_MAIN = "org.apache.catalina.startup.Bootstrap";
    private static final String REQUIRED_SYSTEM_PROPERTY = "catalina.home";
    private static final String REQUIRED_CLASS = "org.apache.catalina.startup.Bootstrap";
    private final List<String> bootstrapMains;

    public TomcatDetector(List<String> bootstrapMains) {
        this.bootstrapMains = CollectionUtils.isEmpty(bootstrapMains) ? Arrays.asList("org.apache.catalina.startup.Bootstrap") : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return TomcatConstants.TOMCAT;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains) && provider.checkSystemProperty(REQUIRED_SYSTEM_PROPERTY) && provider.checkForClass("org.apache.catalina.startup.Bootstrap");
    }
}

