/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc.interceptor.server;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerRequestRecorder;
import com.navercorp.pinpoint.plugin.grpc.GrpcConstants;
import com.navercorp.pinpoint.plugin.grpc.descriptor.GrpcServerCallMethodDescritpro;
import com.navercorp.pinpoint.plugin.grpc.interceptor.server.GrpcServerStreamRequest;
import com.navercorp.pinpoint.plugin.grpc.interceptor.server.GrpcServerStreamRequestAdaptor;

public class ServerStreamCreatedInterceptor
implements AroundInterceptor {
    private static final GrpcServerCallMethodDescritpro GRPC_SERVER_CALL_METHOD_DESCRIPTOR = new GrpcServerCallMethodDescritpro();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final ServerRequestRecorder<GrpcServerStreamRequest> serverRequestRecorder;
    private final RequestTraceReader<GrpcServerStreamRequest> requestTraceReader;

    public ServerStreamCreatedInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        GrpcServerStreamRequestAdaptor requestAdaptor = new GrpcServerStreamRequestAdaptor();
        this.serverRequestRecorder = new ServerRequestRecorder((RequestAdaptor)requestAdaptor);
        this.requestTraceReader = new RequestTraceReader(traceContext, (RequestAdaptor)requestAdaptor, true);
        traceContext.cacheApi((MethodDescriptor)GRPC_SERVER_CALL_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (this.traceContext.currentTraceObject() != null) {
            return;
        }
        GrpcServerStreamRequest request = GrpcServerStreamRequest.create(args);
        if (request == null) {
            return;
        }
        Trace trace = this.createTrace(request);
        if (trace == null || !trace.canSampled()) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(GrpcConstants.SERVER_SERVICE_TYPE_INTERNAL);
        AsyncContext asyncContext = recorder.recordNextAsyncContext(true);
        if (args[0] instanceof AsyncContextAccessor) {
            ((AsyncContextAccessor)args[0])._$PINPOINT$_setAsyncContext(asyncContext);
            this.logger.debug("Set closeable-AsyncContext {}", (Object)asyncContext);
        }
    }

    private Trace createTrace(GrpcServerStreamRequest request) {
        Trace trace = this.requestTraceReader.read((Object)request);
        if (trace.canSampled()) {
            SpanRecorder spanRecorder = trace.getSpanRecorder();
            spanRecorder.recordServiceType(GrpcConstants.SERVER_SERVICE_TYPE);
            spanRecorder.recordApi((MethodDescriptor)GRPC_SERVER_CALL_METHOD_DESCRIPTOR);
            this.serverRequestRecorder.record(spanRecorder, (Object)request);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.deleteTrace(trace);
            return;
        }
        if (!GrpcServerStreamRequest.validate(args)) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.deleteTrace(trace);
        }
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }
}

