/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.undertow.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.undertow.UndertowConfig;
import com.navercorp.pinpoint.plugin.undertow.UndertowConstants;
import com.navercorp.pinpoint.plugin.undertow.UndertowHttpHeaderFilter;
import com.navercorp.pinpoint.plugin.undertow.common.servlet.util.ArgumentValidator;
import com.navercorp.pinpoint.plugin.undertow.interceptor.HttpServerExchangeAdaptor;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class ConnectorsExecuteRootHandlerInterceptor
implements AroundInterceptor {
    private static final String SERVLET_INITIAL_HANDLER_CLASS_NAME = "io.undertow.servlet.handlers.ServletInitialHandler$1";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final MethodDescriptor methodDescriptor;
    private final ArgumentValidator argumentValidator;
    private final UndertowHttpHeaderFilter httpHeaderFilter;
    private final ServletRequestListenerInterceptorHelper<HttpServerExchange> servletRequestListenerInterceptorHelper;

    public ConnectorsExecuteRootHandlerInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.methodDescriptor = descriptor;
        UndertowConfig config = new UndertowConfig(traceContext.getProfilerConfig());
        this.argumentValidator = new ConnectorsArgumentValidator(config.isDeployServlet());
        HttpServerExchangeAdaptor requestAdaptor = new HttpServerExchangeAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<HttpServerExchange> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(UndertowConstants.UNDERTOW, traceContext, (RequestAdaptor)requestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
        this.httpHeaderFilter = new UndertowHttpHeaderFilter(config.isHidePinpointHeader());
    }

    public void before(Object target, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServerExchange request = (HttpServerExchange)args[1];
                this.servletRequestListenerInterceptorHelper.initialized((Object)request, UndertowConstants.UNDERTOW_METHOD, this.methodDescriptor);
                this.httpHeaderFilter.filter(request);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block4;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block4: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServerExchange request = (HttpServerExchange)args[1];
                int statusCode = this.getStatusCode(request);
                this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block4;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    private int getStatusCode(HttpServerExchange response) {
        try {
            return response.getStatusCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static class ConnectorsArgumentValidator
    implements ArgumentValidator {
        private final boolean deployServlet;

        public ConnectorsArgumentValidator(boolean deployServlet) {
            this.deployServlet = deployServlet;
        }

        @Override
        public boolean validate(Object[] args) {
            String httpHandlerClassName;
            if (args == null) {
                return false;
            }
            if (args.length < 2) {
                return false;
            }
            if (!(args[0] instanceof HttpHandler)) {
                return false;
            }
            if (this.deployServlet && !ConnectorsExecuteRootHandlerInterceptor.SERVLET_INITIAL_HANDLER_CLASS_NAME.equals(httpHandlerClassName = args[0].getClass().getName())) {
                return false;
            }
            return args[1] instanceof HttpServerExchange;
        }
    }
}

