/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift;

import com.navercorp.pinpoint.bootstrap.plugin.util.SocketAddressUtils;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.async.TAsyncMethodCall;

public class ThriftUtils {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    private ThriftUtils() {
    }

    private static String convertDotPathToUriPath(String dotPath) {
        if (dotPath == null) {
            return "";
        }
        return DOT_PATTERN.matcher(dotPath).replaceAll("/");
    }

    public static String getProcessorNameAsUri(TBaseProcessor<?> processor) {
        String actualProcessorName = processor.getClass().getName();
        return ThriftUtils.convertDotPathToUriPath(ThriftConstants.PROCESSOR_PATTERN.matcher(actualProcessorName).replaceAll("."));
    }

    public static String getAsyncProcessorNameAsUri(TBaseAsyncProcessor<?> asyncProcessor) {
        String actualAsyncProcessorName = asyncProcessor.getClass().getName();
        return ThriftUtils.convertDotPathToUriPath(ThriftConstants.ASYNC_PROCESSOR_PATTERN.matcher(actualAsyncProcessorName).replaceAll("."));
    }

    public static String getClientServiceName(TServiceClient client) {
        String clientClassName = client.getClass().getName();
        return ThriftUtils.convertDotPathToUriPath(ThriftConstants.CLIENT_PATTERN.split(clientClassName)[0]);
    }

    public static String getAsyncMethodCallName(TAsyncMethodCall<?> asyncMethodCall) {
        String asyncMethodCallClassName = asyncMethodCall.getClass().getName();
        String convertedMethodCallName = ThriftUtils.convertDotPathToUriPath(ThriftConstants.ASYNC_METHOD_CALL_PATTERN.matcher(asyncMethodCallClassName).replaceAll("."));
        String callSuffix = "_call";
        if (convertedMethodCallName.endsWith("_call")) {
            return convertedMethodCallName.substring(0, convertedMethodCallName.length() - "_call".length());
        }
        return convertedMethodCallName;
    }

    public static String getIp(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return SocketAddressUtils.getAddressFirst((InetSocketAddress)inetSocketAddress, (String)"Unknown");
        }
        return "Unknown";
    }

    public static String getIpPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String address = SocketAddressUtils.getAddressFirst((InetSocketAddress)inetSocketAddress);
            if (address == null) {
                return "Unknown";
            }
            return HostAndPort.toHostAndPortString((String)address, (int)inetSocketAddress.getPort());
        }
        return "Unknown";
    }

    public static String getHost(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return SocketAddressUtils.getHostNameFirst((InetSocketAddress)inetSocketAddress, (String)"Unknown");
        }
        return "Unknown";
    }

    public static String getHostPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String hostName = SocketAddressUtils.getHostNameFirst((InetSocketAddress)inetSocketAddress);
            if (hostName == null) {
                return "Unknown";
            }
            return HostAndPort.toHostAndPortString((String)hostName, (int)inetSocketAddress.getPort());
        }
        return "Unknown";
    }
}

