/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.method.ServletSyncMethodDescriptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;

public class ServletRequestListenerInterceptorHelper<T> {
    private static final MethodDescriptor SERVLET_SYNC_METHOD_DESCRIPTOR = new ServletSyncMethodDescriptor();
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isTrace = this.logger.isTraceEnabled();
    private final TraceContext traceContext;
    private final ServiceType serviceType;
    private final RequestAdaptor<T> requestAdaptor;
    private final Filter<String> excludeUrlFilter;
    private final RequestTraceReader<T> requestTraceReader;
    private final ProxyHttpHeaderRecorder<T> proxyHttpHeaderRecorder;
    private final ServerRequestRecorder<T> serverRequestRecorder;
    private final HttpStatusCodeRecorder httpStatusCodeRecorder;
    private final ParameterRecorder<T> parameterRecorder;

    public ServletRequestListenerInterceptorHelper(ServiceType serviceType, TraceContext traceContext, RequestAdaptor<T> requestAdaptor, Filter<String> excludeUrlFilter, ParameterRecorder<T> parameterRecorder) {
        this.serviceType = (ServiceType)Assert.requireNonNull((Object)serviceType, (String)"serviceType must not be null");
        this.traceContext = (TraceContext)Assert.requireNonNull((Object)traceContext, (String)"traceContext must not be null");
        this.requestAdaptor = (RequestAdaptor)Assert.requireNonNull(requestAdaptor, (String)"requestAdaptor must not be null");
        this.requestTraceReader = new RequestTraceReader<T>(traceContext, requestAdaptor, true);
        this.proxyHttpHeaderRecorder = new ProxyHttpHeaderRecorder<T>(traceContext.getProfilerConfig().isProxyHttpHeaderEnable(), requestAdaptor);
        this.excludeUrlFilter = this.defaultFilter(excludeUrlFilter);
        this.parameterRecorder = (ParameterRecorder)Assert.requireNonNull(parameterRecorder, (String)"parameterRecorder must not be null");
        this.serverRequestRecorder = new ServerRequestRecorder<T>(requestAdaptor);
        this.httpStatusCodeRecorder = new HttpStatusCodeRecorder(traceContext.getProfilerConfig().getHttpStatusCodeErrors());
        this.traceContext.cacheApi(SERVLET_SYNC_METHOD_DESCRIPTOR);
    }

    private <T> Filter<T> defaultFilter(Filter<T> excludeUrlFilter) {
        if (excludeUrlFilter == null) {
            return new SkipFilter();
        }
        return excludeUrlFilter;
    }

    public void initialized(T request, ServiceType serviceType, MethodDescriptor methodDescriptor) {
        Trace trace;
        Assert.requireNonNull(request, (String)"request must not be null");
        Assert.requireNonNull((Object)serviceType, (String)"serviceType must not be null");
        Assert.requireNonNull((Object)methodDescriptor, (String)"methodDescriptor must not be null");
        if (this.isDebug) {
            this.logger.debug("Initialized requestEvent. request={}, serviceType={}, methodDescriptor={}", request, serviceType, methodDescriptor);
        }
        if ((trace = this.createTrace(request)) == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(serviceType);
        recorder.recordApi(methodDescriptor);
    }

    private Trace createTrace(T request) {
        String requestURI = this.requestAdaptor.getRpcName(request);
        if (this.excludeUrlFilter.filter(requestURI)) {
            if (this.isTrace) {
                this.logger.trace("Filter requestURI={}", (Object)requestURI);
            }
            return null;
        }
        Trace trace = this.requestTraceReader.read(request);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(this.serviceType);
            recorder.recordApi(SERVLET_SYNC_METHOD_DESCRIPTOR);
            this.serverRequestRecorder.record(recorder, request);
            this.proxyHttpHeaderRecorder.record(recorder, request);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyed(T request, Throwable throwable, int statusCode) {
        Trace trace;
        if (this.isDebug) {
            this.logger.debug("Destroyed requestEvent. request={}, throwable={}, statusCode={}", request, throwable, statusCode);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
            trace.close();
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordException(throwable);
            this.httpStatusCodeRecorder.record(trace.getSpanRecorder(), statusCode);
            this.parameterRecorder.record(recorder, request, throwable);
        }
        finally {
            trace.traceBlockEnd();
            this.traceContext.removeTraceObject();
            trace.close();
        }
    }
}

