/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.ning.asynchttpclient.interceptor;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorderFactory;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.EndPointUtils;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingAsyncHttpClientConstants;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingAsyncHttpClientPluginConfig;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingAsyncHttpClientRequestAdaptorV1;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingCookieExtractorV1;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingEntityExtractorV1;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.RequestHeaderAdaptorV1;
import com.ning.http.client.Request;

public class ExecuteRequestInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(ExecuteRequestInterceptor.class);
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final ClientRequestRecorder<Request> clientRequestRecorder;
    private final CookieRecorder<Request> cookieRecorder;
    private final EntityRecorder<Request> entityRecorder;
    private final RequestTraceWriter<Request> requestTraceWriter;

    public ExecuteRequestInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        NingAsyncHttpClientPluginConfig config = new NingAsyncHttpClientPluginConfig(traceContext.getProfilerConfig());
        NingAsyncHttpClientRequestAdaptorV1 clientRequestAdaptor = new NingAsyncHttpClientRequestAdaptorV1();
        this.clientRequestRecorder = new ClientRequestRecorder(config.isParam(), (ClientRequestAdaptor)clientRequestAdaptor);
        CookieExtractor<Request> cookieExtractor = NingCookieExtractorV1.INSTANCE;
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)config.getHttpDumpConfig(), cookieExtractor);
        EntityExtractor<Request> entityExtractor = NingEntityExtractorV1.INSTANCE;
        this.entityRecorder = EntityRecorderFactory.newEntityRecorder((HttpDumpConfig)config.getHttpDumpConfig(), entityExtractor);
        RequestHeaderAdaptorV1 clientHeaderAdaptor = new RequestHeaderAdaptorV1();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!this.validate(args)) {
            return;
        }
        Request httpRequest = (Request)args[0];
        boolean sampling = trace.canSampled();
        if (!sampling) {
            if (httpRequest != null) {
                this.requestTraceWriter.write((Object)httpRequest);
            }
            return;
        }
        trace.traceBlockBegin();
        SpanEventRecorder recorder = trace.currentSpanEventRecorder();
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordServiceType(NingAsyncHttpClientConstants.ASYNC_HTTP_CLIENT);
        if (httpRequest != null) {
            String host = this.getHost(httpRequest);
            this.requestTraceWriter.write((Object)httpRequest, nextId, host);
        }
    }

    private String getHost(Request httpRequest) {
        return EndPointUtils.getEndPoint(httpRequest.getUrl(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!this.validate(args)) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            Request httpRequest = (Request)args[0];
            if (httpRequest != null) {
                this.clientRequestRecorder.record(recorder, (Object)httpRequest, throwable);
                this.cookieRecorder.record(recorder, (Object)httpRequest, throwable);
                this.entityRecorder.record(recorder, (Object)httpRequest, throwable);
            }
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length == 0 || !(args[0] instanceof Request)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. args={}.", args);
            }
            return false;
        }
        return true;
    }
}

