/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jsp;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.jsp.JspPluginConfig;
import java.security.ProtectionDomain;

public class JspPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JspPluginConfig config = new JspPluginConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("JspPlugin config={}", (Object)config);
        }
        if (!config.isEnable()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("JspPlugin disabled");
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Adding Jasper 2 JSP Engine(Tomcat, Jetty, JBoss).");
        }
        this.addJasper2JspEngine();
    }

    private void addJasper2JspEngine() {
        this.transformTemplate.transform("org.apache.jasper.runtime.HttpJspBase", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod serviceMethod = target.getDeclaredMethod("service", new String[]{"javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"});
                if (serviceMethod != null) {
                    serviceMethod.addInterceptor("com.navercorp.pinpoint.plugin.jsp.interceptor.HttpJspBaseServiceMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

