/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hystrix.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.hystrix.HystrixPluginConstants;

public abstract class HystrixCommandGetFallbackOrThrowExceptionInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HystrixCommandGetFallbackOrThrowExceptionInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        Object exception;
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE);
        recorder.recordException(throwable);
        Attributes attributes = this.getAttributes(args);
        Object message = attributes.getMessage();
        if (message == null) {
            message = attributes.getFailureType();
        }
        if (message != null) {
            recorder.recordAttribute(HystrixPluginConstants.HYSTRIX_FALLBACK_CAUSE_ANNOTATION_KEY, message.toString());
        }
        if ((exception = attributes.getException()) != null) {
            recorder.recordAttribute(HystrixPluginConstants.HYSTRIX_FALLBACK_EXCEPTION_ANNOTATION_KEY, exception.toString());
        }
    }

    protected abstract Attributes getAttributes(Object[] var1);

    protected static interface Attributes {
        public Object getFailureType();

        public Object getMessage();

        public Object getException();
    }
}

