/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public final class StringJoiner {
    private StringJoiner() {
    }

    public static String join(Collection<String> collection, String separator) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            Iterator<String> iterator = collection.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            throw new ConcurrentModificationException("size:" + collection.size());
        }
        int bufferSize = StringJoiner.getBufferSize(collection, separator);
        StringBuilder builder = new StringBuilder(bufferSize);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) break;
            builder.append(separator);
        }
        return builder.toString();
    }

    private static int getBufferSize(Collection<String> collection, String separator) {
        int bufferSize = 0;
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            bufferSize += StringUtils.getLength((String)value, (int)4);
            if (!iterator.hasNext()) break;
            bufferSize += separator.length();
        }
        return bufferSize;
    }
}

