/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.classloader;

import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import com.navercorp.pinpoint.test.classloader.Translator;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformClassLoader
extends ClassLoader {
    private final Logger logger = Logger.getLogger(TransformClassLoader.class.getName());
    private final ConcurrentMap<String, Object> lockMap = new ConcurrentHashMap<String, Object>();
    private final Set<String> notDefinedClass = new CopyOnWriteArraySet<String>();
    private final List<String> notDefinedPackages = new CopyOnWriteArrayList<String>();
    private Translator translator;
    private ProtectionDomain domain;
    public boolean doDelegation = true;

    public TransformClassLoader() {
    }

    public TransformClassLoader(ClassLoader parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.translator = null;
        this.domain = null;
        this.delegateLoadingOf("com.navercorp.pinpoint.test.classloader.TransformClassLoader");
    }

    public void addTranslator(Translator t) {
        this.translator = t;
        t.start();
    }

    public void delegateLoadingOf(String classname) {
        if (classname.endsWith(".")) {
            this.notDefinedPackages.add(classname);
        } else {
            this.notDefinedClass.add(classname);
        }
    }

    public void setDomain(ProtectionDomain d) {
        this.domain = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassFormatError, ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.loadClassByDelegation(name);
            }
            if (c == null) {
                c = this.findClass(name);
            }
            if (c == null) {
                c = this.delegateToParent(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        Object newLock = new Object();
        Object existLock = this.lockMap.putIfAbsent(className, newLock);
        if (existLock != null) {
            return existLock;
        }
        return newLock;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String pname;
        byte[] classfile;
        block12: {
            try {
                if (this.translator != null) {
                    try {
                        classfile = this.translator.transform(name);
                        break block12;
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
                String jarname = "/" + JavaAssistUtils.javaClassNameToJvmResourceName((String)name);
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(jarname);
                if (in == null) {
                    return null;
                }
                classfile = IOUtils.toByteArray((InputStream)in);
            }
            catch (Exception e) {
                throw new ClassNotFoundException("caught an exception while obtaining a class file for " + name, e);
            }
        }
        int i = name.lastIndexOf(46);
        if (i != -1 && this.getPackage(pname = name.substring(0, i)) == null) {
            try {
                this.definePackage(pname, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.domain == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("defineClass:" + name);
            }
            return this.defineClass(name, classfile, 0, classfile.length);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("defineClass:" + name);
        }
        return this.defineClass(name, classfile, 0, classfile.length, this.domain);
    }

    protected Class<?> loadClassByDelegation(String name) throws ClassNotFoundException {
        Class<?> c = null;
        if (this.doDelegation && (this.isJdkPackage(name) || this.notDelegated(name))) {
            c = this.delegateToParent(name);
        }
        return c;
    }

    private boolean isJdkPackage(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.") || name.startsWith("org.w3c.") || name.startsWith("org.xml.");
    }

    private boolean notDelegated(String name) {
        if (this.notDefinedClass.contains(name)) {
            return true;
        }
        for (String notDefinedPackage : this.notDefinedPackages) {
            if (!name.startsWith(notDefinedPackage)) continue;
            return true;
        }
        return false;
    }

    protected Class<?> delegateToParent(String classname) throws ClassNotFoundException {
        ClassLoader cl = this.getParent();
        if (cl != null) {
            return cl.loadClass(classname);
        }
        return this.findSystemClass(classname);
    }
}

